// //\\+-----------------------------------------------------------+//\\
// \\//| ATR_MA_Mtf_Dashboard_ScFix_CRefresh_Tf_Alert_Buttons.mq4  |\\//
// //\\| Created By XplosionKibo 2021.07.05                        |//\\
// \\//+-----------------------------------------------------------+\\//
#property copyright   "2021.07.05 Created By XplosionKibo @ FF"
#property description "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - "
#property description "- Time frame buttons change time frame!"
#property description "- ScFix button sets chart scale fix state On or Off cyclically!"
#property description "- Buttons in column ScFix every other force current or all charts to refresh!"
#property description "- Buttons in row Ma( ) turn alert On or Off for each time frame respectively!"
#property description "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - "

//Modified, 2025/jan/23, by jeanlouie, www.forexfactory.com/jeanlouie
// - alerts optional by tf

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

#property indicator_chart_window
#include <stdlib.mqh>
#include <stderror.mqh>
#import "user32.dll"
int RegisterWindowMessageW(string lpString);
int PostMessageW(int hWnd,int Msg,int wParam,int lParam);
#import
#define cmd_update_window 0x822c
#define wm_command        0x0111
enum fonts
{
font1,/*Aharoni*/ font2,/*Algerian*/ font3,/*Andalus*/ font4,/*Angsana New*/ font5,/*AngsanaUPC*/ font6,/*Aparajita*/ font7,/*Arabic Typesetting*/ font8,/*Arial*/ font9,/*Arial Black*/ 
font10,/*Arial Narrow*/ font11,/*Arial Unicode MS*/ font12,/*Baskenville Old Face*/ font13,/*Batang*/ font14,/*BatangChe*/ font15,/*Bauhaus 93*/ font16,/*Bell MT*/ font17,/*Berlin Sans FB*/ font18,/*Berlin Sans FB Demi*/ font19,/*Bernard MT Condensed*/ 
font20,/*Bodoni MT Poster Compressed*/ font21,/*Book Antiqua*/ font22,/*Bookman Old Style*/ font23,/*Bookshelf Symbol 7*/ font24,/*Britannic Bold*/ font25,/*Broadway*/ font26,/*Browallia New*/ font27,/*Browa|liaUPC*/ font28,/*Brush Script MT*/ font29,/*Calibri*/ 
font30,/*Calibri Light*/ font31,/*Californian FB*/ font32,/*Cambria*/ font33,/*Cambria Math*/ font34,/*Candara*/ font35,/*Centaur*/ font36,/*Century*/ font37,/*Century Gothic*/ font38,/*Chiller*/ font39,/*Colonna MT*/ 
font40,/*Comic Sans MS*/ font41,/*Consolas*/ font42,/*Constantia*/ font43,/*Cooper Black*/ font44,/*Corbel*/ font45,/*Cordia New*/ font46,/*CordiaUPC*/ font47,/*Courier*/ font48,/*Courier New*/ font49,/*DaunPenh*/ 
font50,/*David*/ font51,/*DFKai-SB*/ font52,/*DilleniaUPC*/ font53,/*DokChampa*/ font54,/*Dotum*/ font55,/*DotumChe*/ font56,/*Ebrima*/ font57,/*Estrangelo Edessa*/ font58,/*EucrosiaUPC*/ font59,/*Euphemia*/ 
font60,/*FangSong*/ font61,/*Fixedsys*/ font62,/*Footlight MT Light*/ font63,/*Franklin Gothic Medium*/ font64,/*FrankRuehl*/ font65,/*FreesiaUPC*/ font66,/*Freestyle Script*/ font67,/*Gabriola*/ font68,/*Garamond*/ font69,/*Gautami*/ 
font70,/*Georgia*/ font71,/*Gisha*/ font72,/*Gulim*/ font73,/*GulimChe*/ font74,/*Gungsuh*/ font75,/*GungsuhChe*/ font76,/*Haettenschweiler*/ font77,/*Harlow Solid Italic*/ font78,/*Harrington*/ font79,/*High Tower Text*/ 
font80,/*Impact*/ font81,/*Informal Roman*/ font82,/*IrisUPC*/ font83,/*Iskoola Pota*/ font84,/*JasmineUPC*/ font85,/*Jokerman*/ font86,/*Juice ITC*/ font87,/*KaiTi*/ font88,/*Kalinga*/ font89,/*Kartika*/ 
font90,/*Khmer UI*/ font91,/*KodchiangUPC*/ font92,/*Kokila*/ font93,/*Kristen ITC*/ font94,/*Kunstler Script*/ font95,/*Lao UI*/ font96,/*Latha*/ font97,/*Lato*/ font98,/*Lato Light*/ font99,/*Lato Semibold*/ 
font100,/*Leelawadee*/ font101,/*Levenim MT*/ font102,/*LilyUPC*/ font103,/*Lucida Bright*/ font104,/*Lucida Calligraphy*/ font105,/*Lucida Console*/ font106,/*Lucida Fax*/ font107,/*Lucida Handwriting*/ font108,/*Lucida Sans Unicode*/ font109,/*Magneto*/ 
font110,/*Malgun Gothic*/ font111,/*Mangal*/ font112,/*Marlett*/ font113,/*Matura MT Script Capitals*/ font114,/*Meiryo*/ font115,/*Meiryo UI*/ font116,/*Microsoft Himalaya*/ font117,/*Microsoft JhengHei*/ font118,/*Microsoft New Tai Lue*/ font119,/*Microsoft PhagsPa*/ 
font120,/*Microsoft Sans Serif*/ font121,/*Microsoft Tai Le*/ font122,/*Microsoft Uighur*/ font123,/*Microsoft YaHei*/ font124,/*Microsoft Yi Baiti*/ font125,/*MingLiU*/ font126,/*MingLiU_HKSCS*/ font127,/*MingLiU_HKSCS-ExtB*/ font128,/*MingLiU-ExtB*/ font129,/*Miriam*/ 
font130,/*Miriam Fixed*/ font131,/*Mistral*/ font132,/*Modern*/ font133,/*Modern No.20*/ font134,/*Mongolian Baiti*/ font135,/*Monotype Corsiva*/ font136,/*MoolBoran*/ font137,/*MS Gothic*/ font138,/*MS Mincho*/ font139,/*MS Outlook*/ 
font140,/*MS PGothic*/ font141,/*MS PMincho*/ font142,/*MS Reference Sans Serif*/ font143,/*MS Reference Specialty*/ font144,/*MS Sans Serifv*/ font145,/*MS Serif*/ font146,/*MS UI Gothic*/ font147,/*MT Extra*/ font148,/*MV Boli*/ font149,/*Narkisim*/ 
font150,/*Niagara Engraved*/ font151,/*Niagara Solid*/ font152,/*NSimSun*/ font153,/*Nyala*/ font154,/*Old English Text MT*/ font155,/*Onyx*/ font156,/*Palatino Linotype*/ font157,/*Parchment*/ font158,/*Plantagenet Cherokee*/ font159,/*Playbill*/ 
font160,/*PMingLiU*/ font161,/*PMingLiU-ExtB*/ font162,/*Poor Richard*/ font163,/*Raavi*/ font164,/*Ravie*/ font165,/*Rod*/ font166,/*Roman*/ font167,/*Sakkal Majalla*/ font168,/*Script*/ font169,/*Segoe Print*/ 
font170,/*Segoe Script*/ font171,/*Segoe UI*/ font172,/*Segoe UI Light*/ font173,/*Segoe UI Semibold*/ font174,/*Segoe UI Symbol*/ font175,/*Shonar Bangla*/ font176,/*Showcard Gothic*/ font177,/*Shruti*/ font178,/*SimHei*/ font179,/*Simplified Arabic*/ 
font180,/*Simplified Arabic Fixed*/ font181,/*SimSun*/ font182,/*SimSun-ExtB*/ font183,/*Small Fonts*/ font184,/*Snap ITC*/ font185,/*Stencil*/ font186,/*Sylfaen*/ font187,/*Symbol*/ font188,/*System*/ font189,/*Tahoma*/ 
font190,/*Tempus Sans ITC*/ font191,/*Terminal*/ font192,/*Times New Roman*/ font193,/*Traditional Arabic*/ font194,/*Trebuchet MS*/ font195,/*Tunga*/ font196,/*Utsaah*/ font197,/*Vani*/ font198,/*Verdana*/ font199,/*Vijaya*/ 
font200,/*Viner Hand ITC*/ font201,/*Vivaldi*/ font202,/*Vladimir Script*/ font203,/*Vrinda*/ font204,/*Webdings*/ font205,/*Wide Latin*/ font206,/*Wingdings*/ font207,/*Wingdings 2*/ font208,/*Wingdings 3*/ 
};
string fonts_array[208]=
{
"Aharoni","Algerian","Andalus","Angsana New","AngsanaUPC","Aparajita","Arabic Typesetting","Arial","Arial Black","Arial Narrow","Arial Unicode MS","Baskenville Old Face","Batang",
"BatangChe","Bauhaus 93","Bell MT","Berlin Sans FB","Berlin Sans FB Demi","Bernard MT Condensed","Bodoni MT Poster Compressed","Book Antiqua","Bookman Old Style","Bookshelf Symbol 7",
"Britannic Bold","Broadway","Browallia New","Browa|liaUPC","Brush Script MT","Calibri","Calibri Light","Californian FB","Cambria","Cambria Math","Candara","Centaur","Century","Century Gothic",
"Chiller","Colonna MT","Comic Sans MS","Consolas","Constantia","Cooper Black","Corbel","Cordia New","CordiaUPC","Courier","Courier New","DaunPenh","David","DFKai-SB","DilleniaUPC","DokChampa",
"Dotum","DotumChe","Ebrima","Estrangelo Edessa","EucrosiaUPC","Euphemia","FangSong","Fixedsys","Footlight MT Light","Franklin Gothic Medium","FrankRuehl","FreesiaUPC","Freestyle Script","Gabriola",
"Garamond","Gautami","Georgia","Gisha","Gulim","GulimChe","Gungsuh","GungsuhChe","Haettenschweiler","Harlow Solid Italic","Harrington","High Tower Text","Impact","Informal Roman","IrisUPC",
"Iskoola Pota","JasmineUPC","Jokerman","Juice ITC","KaiTi","Kalinga","Kartika","Khmer UI","KodchiangUPC","Kokila","Kristen ITC","Kunstler Script","Lao UI","Latha","Lato","Lato Light","Lato Semibold",
"Leelawadee","Levenim MT","LilyUPC","Lucida Bright","Lucida Calligraphy","Lucida Console","Lucida Fax","Lucida Handwriting","Lucida Sans Unicode","Magneto","Malgun Gothic","Mangal","Marlett",
"Matura MT Script Capitals","Meiryo","Meiryo UI","Microsoft Himalaya","Microsoft JhengHei","Microsoft New Tai Lue","Microsoft PhagsPa","Microsoft Sans Serif","Microsoft Tai Le","Microsoft Uighur",
"Microsoft YaHei","Microsoft Yi Baiti","MingLiU","MingLiU_HKSCS","MingLiU_HKSCS-ExtB","MingLiU-ExtB","Miriam","Miriam Fixed","Mistral","Modern","Modern No.20","Mongolian Baiti","Monotype Corsiva",
"MoolBoran","MS Gothic","MS Mincho","MS Outlook","MS PGothic","MS PMincho","MS Reference Sans Serif","MS Reference Specialty","MS Sans Serifv","MS Serif","MS UI Gothic","MT Extra","MV Boli","Narkisim",
"Niagara Engraved","Niagara Solid","NSimSun","Nyala","Old English Text MT","Onyx","Palatino Linotype","Parchment","Plantagenet Cherokee","Playbill","PMingLiU","PMingLiU-ExtB","Poor Richard","Raavi",
"Ravie","Rod","Roman","Sakkal Majalla","Script","Segoe Print","Segoe Script","Segoe UI","Segoe UI Light","Segoe UI Semibold","Segoe UI Symbol","Shonar Bangla","Showcard Gothic","Shruti","SimHei",
"Simplified Arabic","Simplified Arabic Fixed","SimSun","SimSun-ExtB","Small Fonts","Snap ITC","Stencil","Sylfaen","Symbol","System","Tahoma","Tempus Sans ITC","Terminal","Times New Roman",
"Traditional Arabic","Trebuchet MS","Tunga","Utsaah","Vani","Verdana","Vijaya","Viner Hand ITC","Vivaldi","Vladimir Script","Vrinda","Webdings","Wide Latin","Wingdings","Wingdings 2","Wingdings 3"
};
enum p
{
   p0,   // Pips
   p1,   // Points
};
enum x
{
   x0,   // None   
   x1,   // Hide M1
   x2,   // Hide M1-M5
   x3,   // Hide M1-M15
   x4,   // Hide M1-M30
   x5,   // Hide M1-H1
   x6,   // Hide MN-H4
   x7,   // Hide MN-D1
   x8,   // Hide MN-W1
   x9,   // Hide MN
};
enum v
{
   v0,   // None
   v1,   // Hide Ma Of Price  
   v2,   // Hide AtrAverage   
   v3,   // Hide Tf Row
   v4,   // Hide AtrCurrent
   v5    // Hide All Except TF
};
enum ref
{
   ref0, // Only Current
   ref1, // All Charts
   ref2  // None
};
  
//----------------------------------------------------------
extern string  DashboardSymbolName                       =  "Current";
extern ref     AutoRefreshChart;                   
extern int     RefreshTimeInSeconds                      =  60;   
extern int     AtrAveragePeriod                          =  13;
extern double  AtrAverageMultiplier                      =  1;
extern int     MaOfAtrAveragePeriod                      =  8;
extern ENUM_MA_METHOD MaOfAtrAverageMethod               =  MODE_EMA;
extern int     AtrCurrentPeriod                          =  1;
extern double  AtrCurrentMultiplier                      =  1;
extern int     MaOfPricePeriod                           =  21;
extern ENUM_MA_METHOD MaOfPriceMethod                    =  MODE_EMA;
extern ENUM_APPLIED_PRICE MaOfPriceAppliedPrice          =  PRICE_CLOSE;  
extern p       DisplayValuesAs;
extern string  Identifier                                =  "Dashboard1";
extern int     BarsLimit                                 =  1000;     
extern ENUM_BASE_CORNER  DisplayCorner                   =  CORNER_RIGHT_UPPER;
extern int     DisplayWindow                             =  0;           
extern bool    AutoXCentered                             =  true;
extern int     XDISTANCE                                 =  0;
extern int     YDISTANCE                                 =  0; 
extern int     ButtonWidth                               =  75;          
extern int     ButtonHigh                                =  20;          
extern double  ButtonsYStep                              =  3;
extern double  ButtonsXStep                              =  3;
extern x       ColumnsToHide;
extern v       RowsToHide;                      
extern fonts   FontName                                  =  font189;
extern int     FontSize                                  =  9;           
extern color   BorderColor                               =  clrDimGray;        
extern color   AtrAverageBGColor                         =  clrBlack; 
extern color   AtrAverageAboveMaOfAtrColor               =  clrOliveDrab;
extern color   AtrAverageBelowMaOfAtrColor               =  clrOrange;
extern color   AtrAverageTilteColor                      =  clrSteelBlue;
extern color   AtrCurrentBGColor                         =  clrBlack;
extern bool    ColorAtrCurrentToBarColor                 =  true;
extern color   AtrCurrentTilteColor                      =  C'92,106,118';
extern color   AtrCurrentNormalColor                     =  clrMediumPurple;
extern color   AtrCurrentBullBarColor                    =  clrMediumSlateBlue;
extern color   AtrCurrentBearBarColor                    =  clrFireBrick;   
extern color   PriceDistanceBGColor                      =  clrBlack; 
extern color   PositivePriceDistanceColor                =  clrTeal;
extern color   NegativePriceDistanceColor                =  clrTomato;    
extern color   PriceDistanceTilteColor                   =  C'60,60,255';
extern color   TFsBGColor                                =  clrBlack; 
extern color   TFsFGColorNormal                          =  clrRoyalBlue; 
extern color   TFsFGColorSelected                        =  clrRed;    
extern color   ScFixTextColorSelected                    =  clrHotPink;
extern bool    TransparentButtons                        =  false;
extern color   AlertSelectedBorderColor                  =  clrDarkGray;
extern ENUM_APPLIED_PRICE AlertPriceType                 =  PRICE_CLOSE;
extern bool    AlertOnCurrentBar                         =  false;
extern int     Alert_Shift                               =  1;
extern bool    Message_Alerts                            =  true;
extern bool    Send_Email                                =  false;
extern bool    Audible_Alerts                            =  false;
extern bool    Push_Notifications                        =  false;
extern string  Sound_File                                =  "alert2.wav";
extern bool    Alert_M1                                  =  true;
extern bool    Alert_M5                                  =  true;
extern bool    Alert_M15                                 =  true;
extern bool    Alert_M30                                 =  true;
extern bool    Alert_H1                                  =  true;
extern bool    Alert_H4                                  =  true;
extern bool    Alert_D1                                  =  true;
extern bool    Alert_W1                                  =  true;
extern bool    Alert_MN1                                 =  true;
//-------------------------------------------------------------------
double   Atrp1M1,Atrp1M5,Atrp1M15,Atrp1M30,Atrp1H1,Atrp1H4,Atrp1D1,Atrp1W1,Atrp1MN,
         Atr2p1M1,Atr2p1M5,Atr2p1M15,Atr2p1M30,Atr2p1H1,Atr2p1H4,Atr2p1D1,Atr2p1W1,Atr2p1MN,
         Pdisp0M1,Pdisp0M5,Pdisp0M15,Pdisp0M30,Pdisp0H1,Pdisp0H4,Pdisp0D1,Pdisp0W1,Pdisp0MN,
         Pdisp1M1,Pdisp1M5,Pdisp1M15,Pdisp1M30,Pdisp1H1,Pdisp1H4,Pdisp1D1,Pdisp1W1,Pdisp1MN,
         AtrM1,AtrM5,AtrM15,AtrM30,AtrH1,AtrH4,AtrD1,AtrW1,AtrMN,Atr2M1,Atr2M5,Atr2M15,Atr2M30,
         Atr2H1,Atr2H4,Atr2D1,Atr2W1,Atr2MN,PDisM1,PDisM5,PDisM15,PDisM30,PDisH1,PDisH4,PDisD1,
         PDisW1,PDisMN,pl1,pl2,pl3,pl4,pl5,pl6,pl7,pl8,pl9,Atr1[],Pdis1[], Atr2[],buffer_atrxM1[],
         buffer_atrxM5[],buffer_atrxM15[],buffer_atrxM30[],buffer_atrxH1[],buffer_atrxH4[],
         buffer_atrxD1[],buffer_atrxW1[],buffer_atrxMN[],buffer_maof_atrxM1[],buffer_maof_atrxM5[],
         buffer_maof_atrxM15[],buffer_maof_atrxM30[],buffer_maof_atrxH1[],mapM1,mapM5,mapM15,mapM30,
         mapH1,mapH4,mapD1,mapW1,mapMN,buffer_maof_atrxH4[],buffer_maof_atrxD1[],buffer_maof_atrxW1[],
         buffer_maof_atrxMN[]; 
         
string   symbx,obj_atr_display,Title0[]={"TF/CS"},Title1[]={"Atr(13)"},Title2[]={"Ma(13)"},z,z1,z2,Title3[]={"Atr(1)"},
         indicator_name="ATR Dashborad ("+"Identifier: "+ Identifier+") ",mg0,mg1,mg2,mg3,mg4,mg5,mg6,mg7,mg8,sn,sctxt;
bool     Only_Current=true,pos,c0,c1,c2,c3,c4,c5,c6,c7,c8,bm1,bm5,bm15,bm30,bmh1,bmh4,bmd1,bmw1,bmn,foundsymbol,
         sxd,m1aflag,m5aflag,m15aflag,m30aflag,h1aflag,h4aflag,d1aflag,w1aflag,mnaflag; 
int      point=10,ButtonsInrow=10,AlertShift,XX,YY;
datetime tam1,tam5,tam15,tam30,tah1,tah4,tad1,taw1,tamn;
static   int tic=0;
   //+------------------------------------------------------------------+
   //| Custom indicator iteration function                              |
   //+------------------------------------------------------------------+
   void myAlert(string xtf, string message)
   {
        if(xtf==mg0 && !Alert_M1)return;
   else if(xtf==mg1 && !Alert_M5)return;
   else if(xtf==mg2 && !Alert_M15)return;
   else if(xtf==mg3 && !Alert_M30)return;
   else if(xtf==mg4 && !Alert_H1)return;
   else if(xtf==mg5 && !Alert_H4)return;
   else if(xtf==mg6 && !Alert_D1)return;
   else if(xtf==mg7 && !Alert_W1)return;
   else if(xtf==mg8 && !Alert_MN1)return;
   
   int handle;
   Print(indicator_name+"@ "+symbx+ xtf +" | "+message);
   if(Audible_Alerts) PlaySound(Sound_File);
   if(Message_Alerts) Alert(indicator_name+"@ "+symbx+ xtf +" | "+message);
   if(Send_Email) SendMail("ATR_Dashboard_Alerts",indicator_name+"@ "+symbx+ xtf +" | "+message);
   handle = FileOpen("ATR_Dashboard_Alerts.txt", FILE_TXT|FILE_READ|FILE_WRITE|FILE_SHARE_READ|FILE_SHARE_WRITE,';');
   if(handle != INVALID_HANDLE)
      {
   FileSeek(handle, 0, SEEK_END);
   FileWrite(handle, indicator_name+"@ "+symbx+"(M"+IntegerToString(Period())+")"+" | "+message);
   FileClose(handle);
      }
   if(Push_Notifications) SendNotification(indicator_name+"@ "+symbx+ xtf +" | "+message);
   }
   //+------------------------------------------------------------------+
   //| Custom indicator initialization function                         |
   //+------------------------------------------------------------------+
   bool symbolcheck(){for(int i=0; i<SymbolsTotal(false); i++) 
   {sn=SymbolName(i,false);
   if((StringFind(sn,DashboardSymbolName,0)!=-1))
   {symbx=sn; return(true);}
   }sn="ScFix";return(false);}
   //+------------------------------------------------------------------+
   //| Custom indicator initialization function                         |
   //+------------------------------------------------------------------+
   int OnInit()
   {
   IndicatorBuffers(18);                  
   SetIndexBuffer(0, buffer_atrxM1);         SetIndexEmptyValue(0, EMPTY_VALUE);       SetIndexStyle(0, DRAW_NONE);
   SetIndexBuffer(1, buffer_atrxM5);         SetIndexEmptyValue(1, EMPTY_VALUE);       SetIndexStyle(1, DRAW_NONE);
   SetIndexBuffer(2, buffer_atrxM15);        SetIndexEmptyValue(2, EMPTY_VALUE);       SetIndexStyle(2, DRAW_NONE);
   SetIndexBuffer(3, buffer_atrxM30);        SetIndexEmptyValue(3, EMPTY_VALUE);       SetIndexStyle(3, DRAW_NONE);
   SetIndexBuffer(4, buffer_atrxH1);         SetIndexEmptyValue(4, EMPTY_VALUE);       SetIndexStyle(4, DRAW_NONE);
   SetIndexBuffer(5, buffer_atrxH4);         SetIndexEmptyValue(5, EMPTY_VALUE);       SetIndexStyle(5, DRAW_NONE);
   SetIndexBuffer(6, buffer_atrxD1);         SetIndexEmptyValue(6, EMPTY_VALUE);       SetIndexStyle(6, DRAW_NONE);
   SetIndexBuffer(7, buffer_atrxW1);         SetIndexEmptyValue(7, EMPTY_VALUE);       SetIndexStyle(7, DRAW_NONE);
   SetIndexBuffer(8, buffer_atrxMN);         SetIndexEmptyValue(8, EMPTY_VALUE);       SetIndexStyle(8, DRAW_NONE);
   SetIndexBuffer(9, buffer_maof_atrxM1);    SetIndexEmptyValue(9, EMPTY_VALUE);       SetIndexStyle(9, DRAW_NONE);
   SetIndexBuffer(10,buffer_maof_atrxM5);    SetIndexEmptyValue(10,EMPTY_VALUE);       SetIndexStyle(10,DRAW_NONE);
   SetIndexBuffer(11,buffer_maof_atrxM15);   SetIndexEmptyValue(11,EMPTY_VALUE);       SetIndexStyle(11,DRAW_NONE);
   SetIndexBuffer(12,buffer_maof_atrxM30);   SetIndexEmptyValue(12,EMPTY_VALUE);       SetIndexStyle(12,DRAW_NONE);
   SetIndexBuffer(13,buffer_maof_atrxH1);    SetIndexEmptyValue(13,EMPTY_VALUE);       SetIndexStyle(13,DRAW_NONE);
   SetIndexBuffer(14,buffer_maof_atrxH4);    SetIndexEmptyValue(14,EMPTY_VALUE);       SetIndexStyle(14,DRAW_NONE);
   SetIndexBuffer(15,buffer_maof_atrxD1);    SetIndexEmptyValue(15,EMPTY_VALUE);       SetIndexStyle(15,DRAW_NONE);
   SetIndexBuffer(16,buffer_maof_atrxW1);    SetIndexEmptyValue(16,EMPTY_VALUE);       SetIndexStyle(16,DRAW_NONE);
   SetIndexBuffer(17,buffer_maof_atrxMN);    SetIndexEmptyValue(17,EMPTY_VALUE);       SetIndexStyle(17,DRAW_NONE);
     
   ChartSetInteger(ChartID(),CHART_EVENT_MOUSE_MOVE,true);
   symbolcheck(); if((symbolcheck()==false)&& DashboardSymbolName!="Current"){symbx=_Symbol; 
   Alert("Not Founding "+DashboardSymbolName+"!? "+ "Please Check Again! Setting Symbol To Current Chart!");}
   
   if(DashboardSymbolName=="Current"||DashboardSymbolName==_Symbol) sctxt="ScFix"; else sctxt=sn;
   if (symbx!=Symbol()) ObjectSetText(Identifier+":TF:0",sctxt);
         
   if(GlobalVariableGet(Identifier+"M1AlertFlag") ==1)  {m1aflag = true;}    ToggleM1();
   if(GlobalVariableGet(Identifier+"M5AlertFlag") ==1)  {m5aflag = true;}    ToggleM5();
   if(GlobalVariableGet(Identifier+"M15AlertFlag")==1)  {m15aflag = true;}   ToggleM15();
   if(GlobalVariableGet(Identifier+"M30AlertFlag")==1)  {m30aflag = true;}   ToggleM30();
   if(GlobalVariableGet(Identifier+"H1AlertFlag") ==1)  {h1aflag = true;}    ToggleH1();
   if(GlobalVariableGet(Identifier+"H4AlertFlag") ==1)  {h4aflag = true;}    ToggleH4();
   if(GlobalVariableGet(Identifier+"D1AlertFlag") ==1)  {d1aflag = true;}    ToggleD1();
   if(GlobalVariableGet(Identifier+"W1AlertFlag") ==1)  {w1aflag = true;}    ToggleW1();
   if(GlobalVariableGet(Identifier+"MNAlertFlag") ==1)  {mnaflag = true;}    ToggleMN();
   
   if (RefreshTimeInSeconds<1)RefreshTimeInSeconds=1;
   if (AutoRefreshChart==ref1 && RefreshTimeInSeconds==0)RefreshTimeInSeconds=2;
   if (AutoRefreshChart==ref0) Only_Current  =true; else Only_Current =false;
   if (AutoRefreshChart==ref2){Only_Current  =true; RefreshTimeInSeconds=10000;} 
   RefreshTimeInSeconds*=100;
   
   return(INIT_SUCCEEDED);
   }
   //+------------------------------------------------------------------+
   //| Custom indicator iteration function                              |
   //+------------------------------------------------------------------+
   int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
   {
   
   int limit = rates_total - prev_calculated;
   //--- counting from 0 to rates_total
   ArraySetAsSeries(buffer_atrxM1,        true);   ArraySetAsSeries(buffer_atrxM5,      true);     ArraySetAsSeries(buffer_atrxM15,     true);
   ArraySetAsSeries(buffer_atrxM30,       true);   ArraySetAsSeries(buffer_atrxH1,      true);     ArraySetAsSeries(buffer_atrxH4,      true);
   ArraySetAsSeries(buffer_atrxD1,        true);   ArraySetAsSeries(buffer_atrxW1,      true);     ArraySetAsSeries(buffer_atrxMN,      true);
   ArraySetAsSeries(buffer_maof_atrxM1,   true);   ArraySetAsSeries(buffer_maof_atrxM5, true);     ArraySetAsSeries(buffer_maof_atrxM15,true);
   ArraySetAsSeries(buffer_maof_atrxM30,  true);   ArraySetAsSeries(buffer_maof_atrxH1, true);     ArraySetAsSeries(buffer_maof_atrxH4, true);
   ArraySetAsSeries(buffer_maof_atrxD1,   true);   ArraySetAsSeries(buffer_maof_atrxW1, true);     ArraySetAsSeries(buffer_maof_atrxMN, true);
     
   //--- initial zero
   if(prev_calculated < 1)
   {
   ArrayInitialize(buffer_atrxM1,      EMPTY_VALUE);  ArrayInitialize(buffer_atrxM5,     EMPTY_VALUE);   ArrayInitialize(buffer_atrxM15,     EMPTY_VALUE);
   ArrayInitialize(buffer_atrxM30,     EMPTY_VALUE);  ArrayInitialize(buffer_atrxH1,     EMPTY_VALUE);   ArrayInitialize(buffer_atrxH4,      EMPTY_VALUE);
   ArrayInitialize(buffer_atrxD1,      EMPTY_VALUE);  ArrayInitialize(buffer_atrxW1,     EMPTY_VALUE);   ArrayInitialize(buffer_atrxMN,      EMPTY_VALUE);
   ArrayInitialize(buffer_maof_atrxM1, EMPTY_VALUE);  ArrayInitialize(buffer_maof_atrxM5,EMPTY_VALUE);   ArrayInitialize(buffer_maof_atrxM15,EMPTY_VALUE);
   ArrayInitialize(buffer_maof_atrxM30,EMPTY_VALUE);  ArrayInitialize(buffer_maof_atrxH1,EMPTY_VALUE);   ArrayInitialize(buffer_maof_atrxH4, EMPTY_VALUE);
   ArrayInitialize(buffer_maof_atrxD1, EMPTY_VALUE);  ArrayInitialize(buffer_maof_atrxW1,EMPTY_VALUE);   ArrayInitialize(buffer_maof_atrxMN, EMPTY_VALUE);
   }
   else
   limit++;
   
   double P= MarketInfo(symbx,MODE_POINT);
   int    D= MarketInfo(symbx,MODE_DIGITS);
   
   // calculating average atr 
   if(RowsToHide!=v2&&RowsToHide!=v5)   
   {calculateatr(AtrAveragePeriod, AtrAverageMultiplier);}
      
   // ma of atr loop 
   for(int b =BarsLimit; b>= 0; b--)
   {
   buffer_maof_atrxM1[b]   = iMAOnArray(buffer_atrxM1,0,MaOfAtrAveragePeriod,0,MaOfAtrAverageMethod,b);
   buffer_maof_atrxM5[b]   = iMAOnArray(buffer_atrxM5,0,MaOfAtrAveragePeriod,0,MaOfAtrAverageMethod,b);
   buffer_maof_atrxM15[b]  = iMAOnArray(buffer_atrxM15,0,MaOfAtrAveragePeriod,0,MaOfAtrAverageMethod,b);
   buffer_maof_atrxM30[b]  = iMAOnArray(buffer_atrxM30,0,MaOfAtrAveragePeriod,0,MaOfAtrAverageMethod,b);
   buffer_maof_atrxH1[b]   = iMAOnArray(buffer_atrxH1,0,MaOfAtrAveragePeriod,0,MaOfAtrAverageMethod,b);
   buffer_maof_atrxH4[b]   = iMAOnArray(buffer_atrxH4,0,MaOfAtrAveragePeriod,0,MaOfAtrAverageMethod,b);
   buffer_maof_atrxD1[b]   = iMAOnArray(buffer_atrxD1,0,MaOfAtrAveragePeriod,0,MaOfAtrAverageMethod,b);
   buffer_maof_atrxW1[b]   = iMAOnArray(buffer_atrxW1,0,MaOfAtrAveragePeriod,0,MaOfAtrAverageMethod,b);
   buffer_maof_atrxMN[b]   = iMAOnArray(buffer_atrxMN,0,MaOfAtrAveragePeriod,0,MaOfAtrAverageMethod,b);
   }
    
   if(buffer_atrxM1[0]>=buffer_maof_atrxM1[0])   c0=true; else c0=false;   if(buffer_atrxM5[0]>=buffer_maof_atrxM5[0])   c1=true;   else c1=false;
   if(buffer_atrxM15[0]>=buffer_maof_atrxM15[0]) c2=true; else c2=false;   if(buffer_atrxM30[0]>=buffer_maof_atrxM30[0]) c3=true;   else c3=false;
   if(buffer_atrxH1[0]>=buffer_maof_atrxH1[0])   c4=true; else c4=false;   if(buffer_atrxH4[0]>=buffer_maof_atrxH4[0])   c5=true;   else c5=false;
   if(buffer_atrxD1[0]>=buffer_maof_atrxD1[0])   c6=true; else c6=false;   if(buffer_atrxW1[0]>=buffer_maof_atrxW1[0])   c7=true;   else c7=false;
   if(buffer_atrxMN[0]>=buffer_maof_atrxMN[0])   c8=true; else c8=false;
       
   Atrp1M1  = MathAbs((NormalizeDouble(((buffer_atrxM1[0])/P),D)));
   Atrp1M5  = MathAbs((NormalizeDouble(((buffer_atrxM5[0])/P),D)));
   Atrp1M15 = MathAbs((NormalizeDouble(((buffer_atrxM15[0])/P),D)));
   Atrp1M30 = MathAbs((NormalizeDouble(((buffer_atrxM30[0])/P),D)));
   Atrp1H1  = MathAbs((NormalizeDouble(((buffer_atrxH1[0])/P),D)));
   Atrp1H4  = MathAbs((NormalizeDouble(((buffer_atrxH4[0])/P),D)));
   Atrp1D1  = MathAbs((NormalizeDouble(((buffer_atrxD1[0])/P),D)));
   Atrp1W1  = MathAbs((NormalizeDouble(((buffer_atrxW1[0])/P),D)));
   Atrp1MN  = MathAbs((NormalizeDouble(((buffer_atrxMN[0])/P),D)));
  
   if(DisplayValuesAs==p0) 
   {AtrM1=Atrp1M1/point;AtrM5=Atrp1M5/point;AtrM15=Atrp1M15/point;AtrM30=Atrp1M30/point;
   AtrH1=Atrp1H1/point;AtrH4=Atrp1H4/point;AtrD1=Atrp1D1/point;AtrW1=Atrp1W1/point;AtrMN=Atrp1MN/point;}
   else                    
   {AtrM1=Atrp1M1;AtrM5=Atrp1M5;AtrM15=Atrp1M15;AtrM30=Atrp1M30;AtrH1=Atrp1H1;AtrH4=Atrp1H4;AtrD1=Atrp1H1;AtrW1=Atrp1W1;AtrMN=Atrp1MN;}
   
   // calculating current atr
   if(RowsToHide!=v4&&RowsToHide!=v5)    
   {calculateatr(AtrCurrentPeriod, AtrCurrentMultiplier);}             
   
   Atr2p1M1  = MathAbs((NormalizeDouble(((buffer_atrxM1[0])/P),D)));
   Atr2p1M5  = MathAbs((NormalizeDouble(((buffer_atrxM5[0])/P),D)));
   Atr2p1M15 = MathAbs((NormalizeDouble(((buffer_atrxM15[0])/P),D)));
   Atr2p1M30 = MathAbs((NormalizeDouble(((buffer_atrxM30[0])/P),D)));
   Atr2p1H1  = MathAbs((NormalizeDouble(((buffer_atrxH1[0])/P),D)));
   Atr2p1H4  = MathAbs((NormalizeDouble(((buffer_atrxH4[0])/P),D)));
   Atr2p1D1  = MathAbs((NormalizeDouble(((buffer_atrxD1[0])/P),D)));
   Atr2p1W1  = MathAbs((NormalizeDouble(((buffer_atrxW1[0])/P),D)));
   Atr2p1MN  = MathAbs((NormalizeDouble(((buffer_atrxMN[0])/P),D)));
   
   if(DisplayValuesAs==p0)
   {Atr2M1=Atr2p1M1/point;Atr2M5=Atr2p1M5/point;Atr2M15=Atr2p1M15/point;Atr2M30=Atr2p1M30/point;
   Atr2H1=Atr2p1H1/point;Atr2H4=Atr2p1H4/point;Atr2D1=Atr2p1D1/point;Atr2W1=Atr2p1W1/point;Atr2MN=Atr2p1MN/point;}
   else                   
   {Atr2M1=Atr2p1M1;Atr2M5=Atr2p1M5;Atr2M15=Atr2p1M15;Atr2M30=Atr2p1M30;Atr2H1=Atr2p1H1;Atr2H4=Atr2p1H4;Atr2D1=Atr2p1H1;Atr2W1=Atr2p1W1;Atr2MN=Atr2p1MN;}
   
   if((iClose(symbx,PERIOD_M1, 0))>(iOpen(symbx,PERIOD_M1, 0))) bm1=true;  else bm1=false;
   if((iClose(symbx,PERIOD_M5, 0))>(iOpen(symbx,PERIOD_M5, 0))) bm5=true;  else bm5=false;
   if((iClose(symbx,PERIOD_M15,0))>(iOpen(symbx,PERIOD_M15,0))) bm15=true; else bm15=false;
   if((iClose(symbx,PERIOD_M30,0))>(iOpen(symbx,PERIOD_M30,0))) bm30=true; else bm30=false;
   if((iClose(symbx,PERIOD_H1, 0))>(iOpen(symbx,PERIOD_H1, 0))) bmh1=true; else bmh1=false;
   if((iClose(symbx,PERIOD_H4, 0))>(iOpen(symbx,PERIOD_H4, 0))) bmh4=true; else bmh4=false;
   if((iClose(symbx,PERIOD_D1, 0))>(iOpen(symbx,PERIOD_D1, 0))) bmd1=true; else bmd1=false;
   if((iClose(symbx,PERIOD_W1, 0))>(iOpen(symbx,PERIOD_W1, 0))) bmw1=true; else bmw1=false;   
   if((iClose(symbx,PERIOD_MN1,0))>(iOpen(symbx,PERIOD_MN1,0))) bmn=true;  else bmn=false;
     
   // calculate price distance to ma
     
   calculate_ma_of_price (MaOfPricePeriod, MaOfPriceMethod, MaOfPriceAppliedPrice,0);
        
   double pdisxM1 = iClose(symbx,PERIOD_M1,0) -mapM1;    if((iClose(symbx,PERIOD_M1, 0) >=mapM1))   pl1=1; else pl1=-1;
   double pdisxM5 = iClose(symbx,PERIOD_M5,0) -mapM5;    if((iClose(symbx,PERIOD_M5, 0) >=mapM5))   pl2=1; else pl2=-1;  
   double pdisxM15= iClose(symbx,PERIOD_M15,0)-mapM15;   if((iClose(symbx,PERIOD_M15,0) >=mapM15))  pl3=1; else pl3=-1;
   double pdisxM30= iClose(symbx,PERIOD_M30,0)-mapM30;   if((iClose(symbx,PERIOD_M30,0) >=mapM30))  pl4=1; else pl4=-1;
   double pdisxH1 = iClose(symbx,PERIOD_H1,0) -mapH1;    if((iClose(symbx,PERIOD_H1, 0) >=mapH1))   pl5=1; else pl5=-1;
   double pdisxH4 = iClose(symbx,PERIOD_H4,0) -mapH4;    if((iClose(symbx,PERIOD_H4, 0) >=mapH4))   pl6=1; else pl6=-1;
   double pdisxD1 = iClose(symbx,PERIOD_D1,0) -mapD1;    if((iClose(symbx,PERIOD_D1, 0) >=mapD1))   pl7=1; else pl7=-1;
   double pdisxW1 = iClose(symbx,PERIOD_W1,0) -mapW1;    if((iClose(symbx,PERIOD_W1, 0) >=mapW1))   pl8=1; else pl8=-1;
   double pdisxMN = iClose(symbx,PERIOD_MN1,0)-mapMN;    if((iClose(symbx,PERIOD_MN1,0) >=mapMN))   pl9=1; else pl9=-1;
       
   Pdisp1M1    = MathAbs((NormalizeDouble(((pdisxM1)/P),D)));
   Pdisp1M5    = MathAbs((NormalizeDouble(((pdisxM5)/P),D)));
   Pdisp1M15   = MathAbs((NormalizeDouble(((pdisxM15)/P),D)));
   Pdisp1M30   = MathAbs((NormalizeDouble(((pdisxM30)/P),D)));
   Pdisp1H1    = MathAbs((NormalizeDouble(((pdisxH1)/P),D)));
   Pdisp1H4    = MathAbs((NormalizeDouble(((pdisxH4)/P),D)));
   Pdisp1D1    = MathAbs((NormalizeDouble(((pdisxD1)/P),D)));
   Pdisp1W1    = MathAbs((NormalizeDouble(((pdisxW1)/P),D)));
   Pdisp1MN    = MathAbs((NormalizeDouble(((pdisxMN)/P),D)));
   
   Pdisp0M1 =  Pdisp1M1/point;    Pdisp0M5 = Pdisp1M5/point;    Pdisp0M15 = Pdisp1M15/point; 
   Pdisp0M30=  Pdisp1M30/point;   Pdisp0H1 = Pdisp1H1/point;    Pdisp0H4  = Pdisp1H4/point;
   Pdisp0D1 =  Pdisp1D1/point;    Pdisp0W1 = Pdisp1W1/point;    Pdisp0MN  = Pdisp1MN/point;
      
   if(DisplayValuesAs==p0)
   {PDisM1=Pdisp0M1*pl1;PDisM5=Pdisp0M5*pl2;PDisM15=Pdisp0M15*pl3;PDisM30=Pdisp0M30*pl4;PDisH1=Pdisp0H1*pl5;
    PDisH4=Pdisp0H4*pl6;PDisD1=Pdisp0D1*pl7;PDisW1=Pdisp0W1*pl8;PDisMN=Pdisp0MN*pl9;}
   
   if(DisplayValuesAs==p1)
   {PDisM1=Pdisp1M1*pl1;PDisM5=Pdisp1M5*pl2;PDisM15=Pdisp1M15*pl3;PDisM30=Pdisp1M30*pl4;PDisH1=Pdisp1H1*pl5;
    PDisH4=Pdisp1H4*pl6;PDisD1=Pdisp1D1*pl7;PDisW1=Pdisp1W1*pl8;PDisMN=Pdisp1MN*pl9;}
    
   //------------------------------------------------------------------------------------------   
   int i,r=0,h=0;  
   if(ColumnsToHide==x1)r=1;if(ColumnsToHide==x2)r=2;if(ColumnsToHide==x3)r=3;if(ColumnsToHide==x4)r=4;
   if(ColumnsToHide==x5)r=5;if(ColumnsToHide==x6)h=4;if(ColumnsToHide==x7)h=3;if(ColumnsToHide==x8)h=2;if(ColumnsToHide==x9)h=1;
   double height=ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0);
   double width=ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0);   
   
   if(DisplayCorner==CORNER_LEFT_UPPER||DisplayCorner==CORNER_LEFT_LOWER)
   {if(AutoXCentered) XX = (width/2)-((10-r-h)*ButtonWidth+(10-r-h-1)*ButtonsXStep)/2; else 
   if (AutoXCentered!=true) XX=XDISTANCE+ButtonsXStep;}
   
   if(DisplayCorner==CORNER_RIGHT_UPPER||DisplayCorner==CORNER_RIGHT_LOWER)
   {if(AutoXCentered) XX = (width/2)-((10-r-h)*ButtonWidth+(10-r-h-1)*ButtonsXStep)/2+ButtonWidth; else 
   if (AutoXCentered!=true) XX=XDISTANCE+ButtonWidth+ButtonsXStep;}
   
   if(DisplayCorner==CORNER_RIGHT_UPPER||DisplayCorner==CORNER_LEFT_UPPER)
   YY=YDISTANCE+ButtonsYStep;
   
   if(DisplayCorner==CORNER_RIGHT_LOWER||DisplayCorner==CORNER_LEFT_LOWER)
   YY=height-height+ButtonHigh+ButtonsYStep;  
   //------------------------------------------------------------------------------------------   
   if(RowsToHide!=v3) 
   {
   int x0=0,y0=0;int ButtonsInRow=10;
   for( i=0+r; i<ArraySize(TF_s)-h; i++)
   
   {if(i>0 && MathMod(i,ButtonsInRow)==0) {x0=0; y0=0;} 
   createButton(Identifier+":Time Frames:"+string(i),TF_s[i],XX+x0,YY+y0); x0+=ButtonWidth+ButtonsXStep;}

   for(i=0; i<ArraySize(Title0); i++)
   {if(i>0 && MathMod(i,ButtonsInRow)==0) {x0=0; y0=0;} 
   createButton(Identifier+":TF:"+string(i),sctxt,XX+x0,YY+y0); x0+=ButtonWidth+ButtonsXStep;}
   }   
   //-------------------------------------------         
   ArrayResize(Atr2,9);
   ArrayFill(Atr2,0,1,DoubleToStr(Atr2M1,1));
   ArrayFill(Atr2,1,1,DoubleToStr(Atr2M5,1));
   ArrayFill(Atr2,2,1,DoubleToStr(Atr2M15,1));
   ArrayFill(Atr2,3,1,DoubleToStr(Atr2M30,1));
   ArrayFill(Atr2,4,1,DoubleToStr(Atr2H1,1));
   ArrayFill(Atr2,5,1,DoubleToStr(Atr2H4,1));
   ArrayFill(Atr2,6,1,DoubleToStr(Atr2D1,1));
   ArrayFill(Atr2,7,1,DoubleToStr(Atr2W1,1));
   ArrayFill(Atr2,8,1,DoubleToStr(Atr2MN,1));
   
   if(RowsToHide!=v2&&RowsToHide!=v5) 
   {
   if( RowsToHide==v3) y0=0; else y0=ButtonHigh+ButtonsYStep;
   x0=0; 
   for( i=0+r; i<ArraySize(Atr1)-h; i++)
   {if(i>0 && MathMod(i,ButtonsInRow)==0) {x0=0; y0=0;} 
   createButton(Identifier+":Atr Current Values:"+int(i),Atr2[i],XX+x0,YY+y0); x0+=ButtonWidth+ButtonsXStep;}
      
   for( i=0; i<ArraySize(Title1); i++)
   {if(i>0 && MathMod(i,ButtonsInRow)==0) {x0=0; y0=0;} 
   createButton(Identifier+":Atr Current Title:"+int(i),"Atr("+IntegerToString(AtrCurrentPeriod,0)+")",XX+x0,YY+y0); x0+=ButtonWidth+ButtonsXStep;}
   }
   //-------------------------------------------
   ArrayResize(Atr1,9);
   ArrayFill(Atr1,0,1,DoubleToStr(AtrM1,1));
   ArrayFill(Atr1,1,1,DoubleToStr(AtrM5,1));
   ArrayFill(Atr1,2,1,DoubleToStr(AtrM15,1));
   ArrayFill(Atr1,3,1,DoubleToStr(AtrM30,1));
   ArrayFill(Atr1,4,1,DoubleToStr(AtrH1,1));
   ArrayFill(Atr1,5,1,DoubleToStr(AtrH4,1));
   ArrayFill(Atr1,6,1,DoubleToStr(AtrD1,1));
   ArrayFill(Atr1,7,1,DoubleToStr(AtrW1,1));
   ArrayFill(Atr1,8,1,DoubleToStr(AtrMN,1));
   
   if(RowsToHide!=v4&&RowsToHide!=v5) 
   {
   x0=0; y0+=ButtonHigh+ButtonsYStep;
   for( i=0+r; i<ArraySize(Atr2)-h; i++)
   {if(i>0 && MathMod(i,ButtonsInRow)==0) {x0=0; y0=0;} 
   createButton(Identifier+":Atr Average Values:"+int(i),Atr1[i],XX+x0,YY+y0); x0+=ButtonWidth+ButtonsXStep;}
      
   for( i=0; i<ArraySize(Title1); i++)
   {if(i>0 && MathMod(i,ButtonsInRow)==0) {x0=0; y0=0;} 
   createButton(Identifier+":Atr Average Title:"+int(i),"Atr("+IntegerToString(AtrAveragePeriod,0)+")",XX+x0,YY+y0); x0+=ButtonWidth+ButtonsXStep;}
   }
   //-------------------------------------------      
   ArrayResize(Pdis1,9);
   ArrayFill(Pdis1,0,1,DoubleToStr(PDisM1,1));
   ArrayFill(Pdis1,1,1,DoubleToStr(PDisM5,1));
   ArrayFill(Pdis1,2,1,DoubleToStr(PDisM15,1));
   ArrayFill(Pdis1,3,1,DoubleToStr(PDisM30,1));
   ArrayFill(Pdis1,4,1,DoubleToStr(PDisH1,1));
   ArrayFill(Pdis1,5,1,DoubleToStr(PDisH4,1));
   ArrayFill(Pdis1,6,1,DoubleToStr(PDisD1,1));
   ArrayFill(Pdis1,7,1,DoubleToStr(PDisW1,1));
   ArrayFill(Pdis1,8,1,DoubleToStr(PDisMN,1));
   
   if(RowsToHide!=v1&&RowsToHide!=v5) 
   {
   x0=0; y0+=ButtonHigh+ButtonsYStep;
   for( i=0+r; i<ArraySize(Pdis1)-h; i++)
   {if(i>0 && MathMod(i,ButtonsInRow)==0) {x0=0; y0=0;} 
   createButton(Identifier+":Pdistance To Ma Values:"+double(i),Pdis1[i],XX+x0,YY+y0); x0+=ButtonWidth+ButtonsXStep;}
      
   for( i=0; i<1; i++)
   {if(i>0 && MathMod(i,ButtonsInRow)==0) {x0=0; y0=0;} 
   createButton(Identifier+":Pdistance To Ma Title:"+double(i),"Ma("+IntegerToString(MaOfPricePeriod,0)+")",XX+x0,YY+y0); x0+=ButtonWidth+ButtonsXStep;}
   }  
   //--------------------------------------------      
   if(AlertOnCurrentBar) AlertShift=0; else AlertShift=Alert_Shift;
   
   if (m1aflag){
   if (iMA(symbx,PERIOD_M1,1,0,MODE_EMA,AlertPriceType,0+AlertShift)>iMA(symbx,PERIOD_M1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_M1,1,0,MODE_EMA,AlertPriceType,1+AlertShift)<iMA(symbx,PERIOD_M1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tam1 != iTime(symbx,PERIOD_M1,0)){mg0=" (M1)";tam1 = iTime(symbx,PERIOD_M1,0); myAlert( mg0,"BUY");}}
   if (iMA(symbx,PERIOD_M1,1,0,MODE_EMA,AlertPriceType,0+AlertShift)<iMA(symbx,PERIOD_M1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_M1,1,0,MODE_EMA,AlertPriceType,1+AlertShift)>iMA(symbx,PERIOD_M1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tam1 != iTime(symbx,PERIOD_M1,0)){mg0=" (M1)";tam1 = iTime(symbx,PERIOD_M1,0); myAlert( mg0,"SELL");}}}
      
   if (m5aflag){
   if (iMA(symbx,PERIOD_M5,1,0,MODE_EMA,AlertPriceType,0+AlertShift)>iMA(symbx,PERIOD_M5,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_M5,1,0,MODE_EMA,AlertPriceType,1+AlertShift)<iMA(symbx,PERIOD_M5,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tam5 != iTime(symbx,PERIOD_M5,0)){mg1=" (M5)";tam5 = iTime(symbx,PERIOD_M5,0); myAlert(mg1,"BUY");}}
   if (iMA(symbx,PERIOD_M5,1,0,MODE_EMA,AlertPriceType,0+AlertShift)<iMA(symbx,PERIOD_M5,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_M5,1,0,MODE_EMA,AlertPriceType,1+AlertShift)>iMA(symbx,PERIOD_M5,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tam5 != iTime(symbx,PERIOD_M5,0)){mg1=" (M5)";tam5 = iTime(symbx,PERIOD_M5,0); myAlert(mg1,"SELL");}}}
   
   if (m15aflag){
   if (iMA(symbx,PERIOD_M15,1,0,MODE_EMA,AlertPriceType,0+AlertShift)>iMA(symbx,PERIOD_M15,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_M15,1,0,MODE_EMA,AlertPriceType,1+AlertShift)<iMA(symbx,PERIOD_M15,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tam15 != iTime(symbx,PERIOD_M15,0)){mg2=" (M15)";tam15 = iTime(symbx,PERIOD_M15,0); myAlert(mg2,"BUY");}}
   if (iMA(symbx,PERIOD_M15,1,0,MODE_EMA,AlertPriceType,0+AlertShift)<iMA(symbx,PERIOD_M15,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_M15,1,0,MODE_EMA,AlertPriceType,1+AlertShift)>iMA(symbx,PERIOD_M15,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tam15 != iTime(symbx,PERIOD_M15,0)){mg2=" (M15)";tam15 = iTime(symbx,PERIOD_M15,0); myAlert(mg2,"SELL");}}}
   
   if (m30aflag){
   if (iMA(symbx,PERIOD_M30,1,0,MODE_EMA,AlertPriceType,0+AlertShift)>iMA(symbx,PERIOD_M30,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_M30,1,0,MODE_EMA,AlertPriceType,1+AlertShift)<iMA(symbx,PERIOD_M30,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tam30 != iTime(symbx,PERIOD_M30,0)){mg3=" (M30)";tam30 = iTime(symbx,PERIOD_M30,0); myAlert(mg3,"BUY");}}
   if (iMA(symbx,PERIOD_M30,1,0,MODE_EMA,AlertPriceType,0+AlertShift)<iMA(symbx,PERIOD_M30,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_M30,1,0,MODE_EMA,AlertPriceType,1+AlertShift)>iMA(symbx,PERIOD_M30,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tam30 != iTime(symbx,PERIOD_M30,0)){mg3=" (M30)";tam30 = iTime(symbx,PERIOD_M30,0); myAlert(mg3,"SELL");}}}
   
   if (h1aflag){
   if (iMA(symbx,PERIOD_H1,1,0,MODE_EMA,AlertPriceType,0+AlertShift)>iMA(symbx,PERIOD_H1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_H1,1,0,MODE_EMA,AlertPriceType,1+AlertShift)<iMA(symbx,PERIOD_H1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tah1 != iTime(symbx,PERIOD_H1,0)){mg4=" (H1)";tah1 = iTime(symbx,PERIOD_H1,0); myAlert(mg4,"BUY");}}
   if (iMA(symbx,PERIOD_H1,1,0,MODE_EMA,AlertPriceType,0+AlertShift)<iMA(symbx,PERIOD_H1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_H1,1,0,MODE_EMA,AlertPriceType,1+AlertShift)>iMA(symbx,PERIOD_H1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))
   {if(tah1 != iTime(symbx,PERIOD_H1,0)){mg4=" (H1)";tah1 = iTime(symbx,PERIOD_H1,0); myAlert(mg4,"SELL");}}}
   
   if (h4aflag){
   if (iMA(symbx,PERIOD_H4,1,0,MODE_EMA,AlertPriceType,0+AlertShift)>iMA(symbx,PERIOD_H4,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_H4,1,0,MODE_EMA,AlertPriceType,1+AlertShift)<iMA(symbx,PERIOD_H4,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tah4 != iTime(symbx,PERIOD_H4,0)){mg5=" (H4)";tah4 = iTime(symbx,PERIOD_H4,0); myAlert(mg5,"BUY");}}
   if (iMA(symbx,PERIOD_H4,1,0,MODE_EMA,AlertPriceType,0+AlertShift)<iMA(symbx,PERIOD_H4,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_H4,1,0,MODE_EMA,AlertPriceType,1+AlertShift)>iMA(symbx,PERIOD_H4,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tah4 != iTime(symbx,PERIOD_H4,0)){mg5=" (H4)";tah4 = iTime(symbx,PERIOD_H4,0); myAlert(mg5,"SELL!");}}}
   
   if (d1aflag){   
   if (iMA(symbx,PERIOD_D1,1,0,MODE_EMA,AlertPriceType,0+AlertShift)>iMA(symbx,PERIOD_D1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_D1,1,0,MODE_EMA,AlertPriceType,1+AlertShift)<iMA(symbx,PERIOD_D1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tad1 != iTime(symbx,PERIOD_D1,0)){mg6=" (D1)";tad1 = iTime(symbx,PERIOD_D1,0); myAlert(mg6,"BUY");}}
   if (iMA(symbx,PERIOD_D1,1,0,MODE_EMA,AlertPriceType,0+AlertShift)<iMA(symbx,PERIOD_D1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_D1,1,0,MODE_EMA,AlertPriceType,1+AlertShift)>iMA(symbx,PERIOD_D1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tad1 != iTime(symbx,PERIOD_D1,0)){mg6=" (D1)";tad1 = iTime(symbx,PERIOD_D1,0); myAlert(mg6,"SELL!");}}}
   
   if (w1aflag){
   if (iMA(symbx,PERIOD_W1,1,0,MODE_EMA,AlertPriceType,0+AlertShift)>iMA(symbx,PERIOD_W1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_W1,1,0,MODE_EMA,AlertPriceType,1+AlertShift)<iMA(symbx,PERIOD_W1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(taw1 != iTime(symbx,PERIOD_W1,0)){mg7=" (W1)";taw1 = iTime(symbx,PERIOD_W1,0); myAlert(mg7,"BUY");}}
   if (iMA(symbx,PERIOD_W1,1,0,MODE_EMA,AlertPriceType,0+AlertShift)<iMA(symbx,PERIOD_W1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_W1,1,0,MODE_EMA,AlertPriceType,1+AlertShift)>iMA(symbx,PERIOD_W1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(taw1 != iTime(symbx,PERIOD_W1,0)){mg7=" (W1)";taw1 = iTime(symbx,PERIOD_W1,0); myAlert(mg7,"SELL");}}}
   
   if (mnaflag){
   if (iMA(symbx,PERIOD_MN1,1,0,MODE_EMA,AlertPriceType,0+AlertShift)>iMA(symbx,PERIOD_MN1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_MN1,1,0,MODE_EMA,AlertPriceType,1+AlertShift)<iMA(symbx,PERIOD_MN1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tamn != iTime(symbx,PERIOD_MN1,0)){mg8=" (MN1)";tamn = iTime(symbx,PERIOD_MN1,0); myAlert(mg8,"BUY");}}
   if (iMA(symbx,PERIOD_MN1,1,0,MODE_EMA,AlertPriceType,0+AlertShift)<iMA(symbx,PERIOD_MN1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,0+AlertShift)
   &&  iMA(symbx,PERIOD_MN1,1,0,MODE_EMA,AlertPriceType,1+AlertShift)>iMA(symbx,PERIOD_MN1,MaOfPricePeriod,0,MaOfPriceMethod,MaOfPriceAppliedPrice,1+AlertShift))  
   {if(tamn != iTime(symbx,PERIOD_MN1,0)){mg8=" (MN1)";tamn = iTime(symbx,PERIOD_MN1,0); myAlert(mg8,"SELL");}}}
   
   setButtonTextColor(); 
   
   if(tic==0) tic=GetTickCount();int k=GetTickCount();
   if(MathAbs(k-tic)>RefreshTimeInSeconds)
   {static int MT4msgIdentifier = 0;if(MT4msgIdentifier==0)
   MT4msgIdentifier=RegisterWindowMessageW("MetaTrader4_Internal_Message");
   long currChart=(Only_Current) ? ChartID() : ChartFirst();
   while(currChart>-1){long prevChart=currChart; 
   long windowHandle=ChartGetInteger(currChart,CHART_WINDOW_HANDLE);
   PostMessageW((int)windowHandle,wm_command,0x822c,1);
   PostMessageW((int)windowHandle,MT4msgIdentifier,2,1);
   currChart=ChartNext(prevChart);if(Only_Current) break;}tic=GetTickCount();}
   ///---------------------------------------------------------------------
   return(rates_total);}
   ///---------------------------------------------------------------------
   double calculate_ma_of_price (int var1, int var2, int var3, int var4)
   {
   mapM1     = iMA(symbx,PERIOD_M1, var1,0,var2,var3,var4);
   mapM5     = iMA(symbx,PERIOD_M5, var1,0,var2,var3,var4);
   mapM15    = iMA(symbx,PERIOD_M15,var1,0,var2,var3,var4);
   mapM30    = iMA(symbx,PERIOD_M30,var1,0,var2,var3,var4);
   mapH1     = iMA(symbx,PERIOD_H1, var1,0,var2,var3,var4);
   mapH4     = iMA(symbx,PERIOD_H4, var1,0,var2,var3,var4);
   mapD1     = iMA(symbx,PERIOD_D1, var1,0,var2,var3,var4);
   mapW1     = iMA(symbx,PERIOD_W1, var1,0,var2,var3,var4);
   mapMN     = iMA(symbx,PERIOD_MN1,var1,0,var2,var3,var4);
   return(0);
   }  
   ////-------------------------------------------------------------------
   double calculateatr( int Atrperiod, int AtrMultiplier)
   {for(int f=BarsLimit-1;f>=0;f--){
   buffer_atrxM1[f]  = iATR(symbx,PERIOD_M1, Atrperiod,f)*AtrMultiplier;
   buffer_atrxM5[f]  = iATR(symbx,PERIOD_M5, Atrperiod,f)*AtrMultiplier;
   buffer_atrxM15[f] = iATR(symbx,PERIOD_M15,Atrperiod,f)*AtrMultiplier;
   buffer_atrxM30[f] = iATR(symbx,PERIOD_M30,Atrperiod,f)*AtrMultiplier;
   buffer_atrxH1[f]  = iATR(symbx,PERIOD_H1, Atrperiod,f)*AtrMultiplier;
   buffer_atrxH4[f]  = iATR(symbx,PERIOD_H4, Atrperiod,f)*AtrMultiplier;
   buffer_atrxD1[f]  = iATR(symbx,PERIOD_D1, Atrperiod,f)*AtrMultiplier;
   buffer_atrxW1[f]  = iATR(symbx,PERIOD_W1, Atrperiod,f)*AtrMultiplier;
   buffer_atrxMN[f]  = iATR(symbx,PERIOD_MN1,Atrperiod,f)*AtrMultiplier;}
   return(0);}
   ///------------------------------------------------------------------+
   string TF_s[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"}; 
   int    TF_i[] = {1,5,15,30,60,240,1440,10080,43200}; 
   //+------------------------------------------------------------------+
   string timeFrameToString(int tf)
   {for(int i=ArraySize(TF_i)-1; i>=0; i--)
   if(tf==TF_i[i]) return(TF_s[i]);return("");} 
   //+------------------------------------------------------------------+
   int stringToTimeFrame(string tf)
   {for(int i=ArraySize(TF_s)-1; i>=0; i--)
   if(tf==TF_s[i]) return(TF_i[i]);return(0);}
   //+------------------------------------------------------------------+
   //| Deinit                                                           |         
   //+------------------------------------------------------------------+
   int deinit(){for (int i = ObjectsTotal() - 1; i >= 0; i--)
   {z = ObjectName(i);
   if((StringFind(z,Identifier,0)!=-1)&&((StringFind(z,":Time Frames:",0)!=-1)||(StringFind(z,":TF:",0)!=-1)))
   ObjectDelete(z);
   if((StringFind(z,Identifier,0)!=-1)&&((StringFind(z,":Atr Average Values:")!=-1)||(StringFind(z,":Atr Average Title:")!=-1)))
   ObjectDelete(z);
   if((StringFind(z,Identifier,0)!=-1)&&((StringFind(z,":Pdistance To Ma Values:",0)!=-1)||(StringFind(z,":Pdistance To Ma Title:",0)!=-1)))
   ObjectDelete(z);
   if((StringFind(z,Identifier,0)!=-1)&&((StringFind(z,":Atr Current Values:")!=-1)||(StringFind(z,":Atr Current Title:")!=-1)))
   ObjectDelete(z);}
   return(0);}
   //+------------------------------------------------------------------
   void setButtonTextColor()
   {string lookFor = Identifier+":Time Frames:"; string lookForA = Identifier+":TF:";
   int lookForLength = StringLen(lookFor); int lookForLengthA = StringLen(lookForA);
   
   if(m1aflag)
   ObjectSet(Identifier+":Pdistance To Ma Values:0",OBJPROP_BORDER_COLOR,AlertSelectedBorderColor);
   else ObjectSet(Identifier+":Pdistance To Ma Values:0",OBJPROP_BORDER_COLOR,BorderColor);
   if(m5aflag)
   ObjectSet(Identifier+":Pdistance To Ma Values:1",OBJPROP_BORDER_COLOR,AlertSelectedBorderColor);
   else ObjectSet(Identifier+":Pdistance To Ma Values:1",OBJPROP_BORDER_COLOR,BorderColor);
   if(m15aflag)
   ObjectSet(Identifier+":Pdistance To Ma Values:2",OBJPROP_BORDER_COLOR,AlertSelectedBorderColor);
   else ObjectSet(Identifier+":Pdistance To Ma Values:2",OBJPROP_BORDER_COLOR,BorderColor);
   if(m30aflag)
   ObjectSet(Identifier+":Pdistance To Ma Values:3",OBJPROP_BORDER_COLOR,AlertSelectedBorderColor);
   else ObjectSet(Identifier+":Pdistance To Ma Values:3",OBJPROP_BORDER_COLOR,BorderColor);
   if(h1aflag)
   ObjectSet(Identifier+":Pdistance To Ma Values:4",OBJPROP_BORDER_COLOR,AlertSelectedBorderColor);
   else ObjectSet(Identifier+":Pdistance To Ma Values:4",OBJPROP_BORDER_COLOR,BorderColor);
   if(h4aflag)
   ObjectSet(Identifier+":Pdistance To Ma Values:5",OBJPROP_BORDER_COLOR,AlertSelectedBorderColor);
   else ObjectSet(Identifier+":Pdistance To Ma Values:5",OBJPROP_BORDER_COLOR,BorderColor);
   if(d1aflag)
   ObjectSet(Identifier+":Pdistance To Ma Values:6",OBJPROP_BORDER_COLOR,AlertSelectedBorderColor);
   else ObjectSet(Identifier+":Pdistance To Ma Values:6",OBJPROP_BORDER_COLOR,BorderColor);
   if(w1aflag)
   ObjectSet(Identifier+":Pdistance To Ma Values:7",OBJPROP_BORDER_COLOR,AlertSelectedBorderColor);
   else ObjectSet(Identifier+":Pdistance To Ma Values:7",OBJPROP_BORDER_COLOR,BorderColor);
   if(mnaflag)
   ObjectSet(Identifier+":Pdistance To Ma Values:8",OBJPROP_BORDER_COLOR,AlertSelectedBorderColor);
   else ObjectSet(Identifier+":Pdistance To Ma Values:8",OBJPROP_BORDER_COLOR,BorderColor);                              
   //----------------------------------------------------                  
   for(int i=ObjectsTotal(); i>=0; i--){string objectName=ObjectName(i);
   if(StringFind(objectName,Identifier+":Atr Average Title:0",0)!=-1)
   ObjectSetInteger(0,Identifier+":Atr Average Title:0",OBJPROP_COLOR,AtrAverageTilteColor);
   if(StringFind(objectName,Identifier+":Atr Current Title:0",0)!=-1)
   ObjectSetInteger(0,Identifier+":Atr Current Title:0",OBJPROP_COLOR,AtrCurrentTilteColor);
   if(StringFind(objectName,Identifier+":Pdistance To Ma Title:0",0)!=-1)
   ObjectSetInteger(0,Identifier+":Pdistance To Ma Title:0",OBJPROP_COLOR,PriceDistanceTilteColor);
   //----------------------------------------------------
   if(StringSubstr(objectName,0,lookForLength)==lookFor)
   {int time = stringToTimeFrame(ObjectGetString(0,objectName,OBJPROP_TEXT));
   if(time != _Period)
   ObjectSet(objectName,OBJPROP_COLOR,TFsFGColorNormal);
   else  ObjectSet(objectName,OBJPROP_COLOR,TFsFGColorSelected);}
   //----------------------------------------------------
   if(StringFind(objectName,Identifier+":TF:0",0)!=-1)
   {if (ChartGetInteger(0,CHART_SCALEFIX,true))
   ObjectSet(objectName,OBJPROP_COLOR,ScFixTextColorSelected);
   else  ObjectSet(objectName,OBJPROP_COLOR,TFsFGColorNormal);}
   //----------------------------------------------------
   if(StringFind(objectName,Identifier+":Pdistance To Ma Values:0",0)!=-1)
   {if (PDisM1<0)
   ObjectSet(objectName,OBJPROP_COLOR,NegativePriceDistanceColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,PositivePriceDistanceColor);}
   if(StringFind(objectName,Identifier+":Pdistance To Ma Values:1",0)!=-1)
   {if (PDisM5<0)
   ObjectSet(objectName,OBJPROP_COLOR,NegativePriceDistanceColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,PositivePriceDistanceColor);}              
   if(StringFind(objectName,Identifier+":Pdistance To Ma Values:2",0)!=-1)
   {if (PDisM15<0)
   {ObjectSet(objectName,OBJPROP_COLOR,NegativePriceDistanceColor);}
   else  ObjectSet(objectName,OBJPROP_COLOR,PositivePriceDistanceColor);}
   if(StringFind(objectName,Identifier+":Pdistance To Ma Values:3",0)!=-1)
   {if (PDisM30<0)
   ObjectSet(objectName,OBJPROP_COLOR,NegativePriceDistanceColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,PositivePriceDistanceColor);}              
   if(StringFind(objectName,Identifier+":Pdistance To Ma Values:4",0)!=-1)
   {if (PDisH1<0)
   ObjectSet(objectName,OBJPROP_COLOR,NegativePriceDistanceColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,PositivePriceDistanceColor);}
   if(StringFind(objectName,Identifier+":Pdistance To Ma Values:5",0)!=-1)
   {if (PDisH4<0)
   ObjectSet(objectName,OBJPROP_COLOR,NegativePriceDistanceColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,PositivePriceDistanceColor);}
   if(StringFind(objectName,Identifier+":Pdistance To Ma Values:6",0)!=-1)
   {if (PDisD1<0)
   ObjectSet(objectName,OBJPROP_COLOR,NegativePriceDistanceColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,PositivePriceDistanceColor);}
   if(StringFind(objectName,Identifier+":Pdistance To Ma Values:7",0)!=-1)
   {if (PDisW1<0)
   ObjectSet(objectName,OBJPROP_COLOR,NegativePriceDistanceColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,PositivePriceDistanceColor);}
   if(StringFind(objectName,Identifier+":Pdistance To Ma Values:8",0)!=-1)
   {if (PDisMN<0)
   ObjectSet(objectName,OBJPROP_COLOR,NegativePriceDistanceColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,PositivePriceDistanceColor);}
   //----------------------------------------------------
   if(   StringFind(objectName,Identifier+":Atr Average Values:0",0)!=-1)
   {if   (c0)ObjectSet(objectName,OBJPROP_COLOR,AtrAverageAboveMaOfAtrColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrAverageBelowMaOfAtrColor);}
   if    (StringFind(objectName,Identifier+":Atr Average Values:1",0)!=-1)
   {if   (c1)ObjectSet(objectName,OBJPROP_COLOR,AtrAverageAboveMaOfAtrColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrAverageBelowMaOfAtrColor);}
   if    (StringFind(objectName,Identifier+":Atr Average Values:2",0)!=-1)
   {if   (c2)ObjectSet(objectName,OBJPROP_COLOR,AtrAverageAboveMaOfAtrColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrAverageBelowMaOfAtrColor);}         
   if    (StringFind(objectName,Identifier+":Atr Average Values:3",0)!=-1)
   {if   (c3)ObjectSet(objectName,OBJPROP_COLOR,AtrAverageAboveMaOfAtrColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrAverageBelowMaOfAtrColor);}
   if    (StringFind(objectName,Identifier+":Atr Average Values:4",0)!=-1)
   {if   (c4)ObjectSet(objectName,OBJPROP_COLOR,AtrAverageAboveMaOfAtrColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrAverageBelowMaOfAtrColor);}
   if    (StringFind(objectName,Identifier+":Atr Average Values:5",0)!=-1)
   {if   (c5)ObjectSet(objectName,OBJPROP_COLOR,AtrAverageAboveMaOfAtrColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrAverageBelowMaOfAtrColor);}
   if    (StringFind(objectName,Identifier+":Atr Average Values:6",0)!=-1)
   {if   (c6)ObjectSet(objectName,OBJPROP_COLOR,AtrAverageAboveMaOfAtrColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrAverageBelowMaOfAtrColor);}
   if    (StringFind(objectName,Identifier+":Atr Average Values:7",0)!=-1)
   {if   (c7)ObjectSet(objectName,OBJPROP_COLOR,AtrAverageAboveMaOfAtrColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrAverageBelowMaOfAtrColor);}
   if    (StringFind(objectName,Identifier+":Atr Average Values:8",0)!=-1)
   {if   (c8)ObjectSet(objectName,OBJPROP_COLOR,AtrAverageAboveMaOfAtrColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrAverageBelowMaOfAtrColor);}
   //----------------------------------------------------
   if    (StringFind(objectName,Identifier+":Atr Current Values:0",0)!=-1)
   {if   (ColorAtrCurrentToBarColor && bm1)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBullBarColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBearBarColor);
   if    (!ColorAtrCurrentToBarColor)
         {ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentNormalColor);}}    
   if    (StringFind(objectName,Identifier+":Atr Current Values:1",0)!=-1)
   {if   (ColorAtrCurrentToBarColor && bm5)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBullBarColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBearBarColor);
   if    (!ColorAtrCurrentToBarColor)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentNormalColor);}         
   if    (StringFind(objectName,Identifier+":Atr Current Values:2",0)!=-1)
   {if   (ColorAtrCurrentToBarColor && bm15)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBullBarColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBearBarColor);
   if    (!ColorAtrCurrentToBarColor)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentNormalColor);}               
   if    (StringFind(objectName,Identifier+":Atr Current Values:3",0)!=-1)
   {if   (ColorAtrCurrentToBarColor && bm30)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBullBarColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBearBarColor);
   if    (!ColorAtrCurrentToBarColor)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentNormalColor);}                     
   if    (StringFind(objectName,Identifier+":Atr Current Values:4",0)!=-1)
   {if   (ColorAtrCurrentToBarColor && bmh1)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBullBarColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBearBarColor);
   if    (!ColorAtrCurrentToBarColor)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentNormalColor);}         
   if    (StringFind(objectName,Identifier+":Atr Current Values:5",0)!=-1)
   {if   (ColorAtrCurrentToBarColor && bmh4)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBullBarColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBearBarColor);
   if    (!ColorAtrCurrentToBarColor)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentNormalColor);}                
   if    (StringFind(objectName,Identifier+":Atr Current Values:6",0)!=-1)
   {if   (ColorAtrCurrentToBarColor && bmd1)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBullBarColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBearBarColor);
   if    (!ColorAtrCurrentToBarColor)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentNormalColor);}                               
   if    (StringFind(objectName,Identifier+":Atr Current Values:7",0)!=-1)
   {if   (ColorAtrCurrentToBarColor && bmw1)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBullBarColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBearBarColor);
   if    (!ColorAtrCurrentToBarColor)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentNormalColor);}         
   if    (StringFind(objectName,Identifier+":Atr Current Values:8",0)!=-1)
   {if   (ColorAtrCurrentToBarColor && bmn)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBullBarColor);
   else  ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentBearBarColor);
   if    (!ColorAtrCurrentToBarColor)
         ObjectSet(objectName,OBJPROP_COLOR,AtrCurrentNormalColor);}
   }}
   //--------------------------------------------------------------------
   void OnChartEvent(const int id,const long &lparam,const double &dparam,const string &sparam)
   {if (id==CHARTEVENT_OBJECT_CLICK && ObjectType(sparam)==OBJ_BUTTON)
   {if(StringFind(sparam,Identifier+":Time Frames:",0)!=-1) 
   {ChartSetSymbolPeriod(0,symbx,stringToTimeFrame(ObjectGetString(0,sparam,OBJPROP_TEXT)));}}
   if (ChartGetInteger(0,CHART_SCALEFIX,true)) bool scfix=false; else scfix=true;          
   {if(StringFind(sparam,Identifier+":TF:",0)!=-1)ChartSetInteger(0, CHART_SCALEFIX,0,scfix);}
   if(id==CHARTEVENT_OBJECT_CLICK)
   {Print("The mouse has been clicked on the object with name '"+sparam+"'");}
   //+-------------------------------------------------------------------+
   if(sparam==Identifier+":Pdistance To Ma Values:0") {ToggleM1 ();}
   if(sparam==Identifier+":Pdistance To Ma Values:1") {ToggleM5 ();}
   if(sparam==Identifier+":Pdistance To Ma Values:2") {ToggleM15();}
   if(sparam==Identifier+":Pdistance To Ma Values:3") {ToggleM30();}
   if(sparam==Identifier+":Pdistance To Ma Values:4") {ToggleH1 ();}
   if(sparam==Identifier+":Pdistance To Ma Values:5") {ToggleH4 ();}
   if(sparam==Identifier+":Pdistance To Ma Values:6") {ToggleD1 ();}
   if(sparam==Identifier+":Pdistance To Ma Values:7") {ToggleW1 ();}
   if(sparam==Identifier+":Pdistance To Ma Values:8") {ToggleMN ();}
   //+-------------------------------------------------------------------+ 
   if (id==CHARTEVENT_OBJECT_CLICK && ObjectType(sparam)==OBJ_BUTTON){
   if (sparam==Identifier+":Atr Average Title:0")     {UpdateChartWindows(true); ObjectSetInteger(0,sparam,OBJPROP_STATE,false);}
   if (sparam==Identifier+":Atr Current Title:0")     {UpdateChartWindows(false);ObjectSetInteger(0,sparam,OBJPROP_STATE,false);}
   if (sparam==Identifier+":Pdistance To Ma Title:0") {UpdateChartWindows(true); ObjectSetInteger(0,sparam,OBJPROP_STATE,false);}}}
   //+-------------------------------------------------------------------+ 
   void ToggleM1()   {m1aflag=!m1aflag;   GlobalVariableSet(Identifier+"M1AlertFlag", !m1aflag ?  1 : 0);
   if(GlobalVariableGet (Identifier+"M1AlertFlag") ==1)  ObjectSetText(Identifier+":Pdistance To Ma Values:0","Alert OFF");
   if(GlobalVariableGet (Identifier+"M1AlertFlag") ==0)  ObjectSetText(Identifier+":Pdistance To Ma Values:0","Alert ON");}
   void ToggleM5()   {m5aflag=!m5aflag;   GlobalVariableSet(Identifier+"M5AlertFlag", !m5aflag ?  1 : 0);
   if(GlobalVariableGet (Identifier+"M5AlertFlag") ==1)  ObjectSetText(Identifier+":Pdistance To Ma Values:1","Alert OFF");
   if(GlobalVariableGet (Identifier+"M5AlertFlag") ==0)  ObjectSetText(Identifier+":Pdistance To Ma Values:1","Alert ON");}
   void ToggleM15()  {m15aflag=!m15aflag; GlobalVariableSet(Identifier+"M15AlertFlag",!m15aflag ? 1 : 0);
   if(GlobalVariableGet (Identifier+"M15AlertFlag")==1)  ObjectSetText(Identifier+":Pdistance To Ma Values:2","Alert OFF");
   if(GlobalVariableGet (Identifier+"M15AlertFlag")==0)  ObjectSetText(Identifier+":Pdistance To Ma Values:2","Alert ON");}
   void ToggleM30()  {m30aflag=!m30aflag; GlobalVariableSet(Identifier+"M30AlertFlag",!m30aflag ? 1 : 0);
   if(GlobalVariableGet (Identifier+"M30AlertFlag")==1)  ObjectSetText(Identifier+":Pdistance To Ma Values:3","Alert OFF");
   if(GlobalVariableGet (Identifier+"M30AlertFlag")==0)  ObjectSetText(Identifier+":Pdistance To Ma Values:3","Alert ON");}
   void ToggleH1()   {h1aflag=!h1aflag;   GlobalVariableSet(Identifier+"H1AlertFlag", !h1aflag ?  1 : 0);
   if(GlobalVariableGet (Identifier+"H1AlertFlag") ==1)  ObjectSetText(Identifier+":Pdistance To Ma Values:4","Alert OFF");
   if(GlobalVariableGet (Identifier+"H1AlertFlag") ==0)  ObjectSetText(Identifier+":Pdistance To Ma Values:4","Alert ON");}
   void ToggleH4()   {h4aflag=!h4aflag;   GlobalVariableSet(Identifier+"H4AlertFlag", !h4aflag ?  1 : 0);
   if(GlobalVariableGet (Identifier+"H4AlertFlag") ==1)  ObjectSetText(Identifier+":Pdistance To Ma Values:5","Alert OFF");
   if(GlobalVariableGet (Identifier+"H4AlertFlag") ==0)  ObjectSetText(Identifier+":Pdistance To Ma Values:5","Alert ON");}
   void ToggleD1()   {d1aflag=!d1aflag;   GlobalVariableSet(Identifier+"D1AlertFlag", !d1aflag ?  1 : 0);
   if(GlobalVariableGet (Identifier+"D1AlertFlag") ==1)  ObjectSetText(Identifier+":Pdistance To Ma Values:6","Alert OFF");
   if(GlobalVariableGet (Identifier+"D1AlertFlag") ==0)  ObjectSetText(Identifier+":Pdistance To Ma Values:6","Alert ON");}
   void ToggleW1()   {w1aflag=!w1aflag;   GlobalVariableSet(Identifier+"W1AlertFlag", !w1aflag ?  1 : 0);
   if(GlobalVariableGet (Identifier+"W1AlertFlag") ==1)  ObjectSetText(Identifier+":Pdistance To Ma Values:7","Alert OFF");
   if(GlobalVariableGet (Identifier+"W1AlertFlag") ==0)  ObjectSetText(Identifier+":Pdistance To Ma Values:7","Alert ON");}
   void ToggleMN()   {mnaflag=!mnaflag;   GlobalVariableSet(Identifier+"MNAlertFlag", !mnaflag ?  1 : 0);
   if(GlobalVariableGet (Identifier+"MNAlertFlag") ==1)  ObjectSetText(Identifier+":Pdistance To Ma Values:8","Alert OFF");
   if(GlobalVariableGet (Identifier+"MNAlertFlag") ==0)  ObjectSetText(Identifier+":Pdistance To Ma Values:8","Alert ON");}
  //+--------------------------------------------------------------------+
   void createButton(string name,string caption,int x0,int y0){if(ObjectFind(name)!=0)
   ObjectCreate(name,OBJ_BUTTON,DisplayWindow,0,0,0,0,0,0);
   ObjectSet(name,OBJPROP_CORNER,0);
   ObjectSet(name,OBJPROP_XDISTANCE,x0);
   ObjectSet(name,OBJPROP_YDISTANCE,y0);
   ObjectSet(name,OBJPROP_XSIZE,ButtonWidth);
   ObjectSet(name,OBJPROP_YSIZE,ButtonHigh);
   ObjectSetText(name,caption,FontSize,fonts_array[FontName]);
   ObjectSetString(0,name,OBJPROP_FONT,fonts_array[FontName]);
   ObjectSet(name,OBJPROP_FONTSIZE,FontSize);
   ObjectSet(name,OBJPROP_BORDER_TYPE,BORDER_FLAT);
   ObjectSet(name,OBJPROP_COLOR,TFsFGColorNormal);
   ObjectSet(name,OBJPROP_BGCOLOR,TFsBGColor);
   ObjectSet(name,OBJPROP_BACK,TransparentButtons);
   ObjectSet(name,OBJPROP_BORDER_COLOR,BorderColor);
   ObjectSet(name,OBJPROP_STATE,false);
   ObjectSet(name,OBJPROP_HIDDEN,false);
   ObjectSet(name,OBJPROP_CORNER,DisplayCorner);z=name;}
//+------------------------------------------------------------------+ 
   void UpdateChartWindows(bool onlyCurrent)
   {static int MT4msgIdentifier=0;
   if (MT4msgIdentifier==0)MT4msgIdentifier=RegisterWindowMessageW("MetaTrader4_Internal_Message");
   long  currChart=(onlyCurrent) ? ChartID() : ChartFirst();
   while (currChart>-1){long prevChart = currChart; 
   long windowHandle = ChartGetInteger(currChart,CHART_WINDOW_HANDLE);
   PostMessageW((int)windowHandle,wm_command,0x822c,1);
   PostMessageW((int)windowHandle,MT4msgIdentifier,2,1);
   currChart = ChartNext(prevChart);if (onlyCurrent) break;}return;}
//+------------------------------------------------------------------+ 
  
  



