#property copyright "Copyright ?2012-2014 Andrew Sumner"
#property link      "http://www.stevehopwoodforex.com/phpBB3/viewtopic.php?f=27&t=514"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 clrRed
#property indicator_color2 clrRed
#property indicator_color3 clrDodgerBlue
#property indicator_color4 clrDodgerBlue

extern int    BackLimit   = 10000;
extern int    TimeFrame   = 0;
extern string TimeString  = "0=Current, 15=M15, 30=M30, 60=H1, 240=H4, 1440=Day, 10080=Week, 43200=Month";

extern string  SHOW_ZONES            = "==========SHOW ZONES==========";
extern bool   zone_show_zones        = false;  // Changed from true to false to remove zone rectangles
extern bool   zone_show_untested     = true;
extern bool   zone_show_verified     = true;
extern bool   zone_show_truncoat     = true;
extern bool   zone_show_weak         = false;
extern bool   zone_show_possible     = false;
extern bool   zone_showbroken        = false;

extern string  MARK_CANDLE_SETTINGS  = "==========MARK CANDLE SETTINGS==========";
extern bool    mark_candle_high_low  = true;  // Mark the high and low of zone-forming candles
extern bool    use_zone_colors_for_candles = true; // Use zone colors for candle marks
extern color   mark_candle_color     = clrYellow; // Color for candle marks (if not using zone colors)
extern int     mark_candle_style     = 2;     // Style for candle marks (2 = dotted)
extern int     mark_candle_width     = 1;     // Width for candle marks
extern bool    show_filled_body      = true;  // Show filled rectangles for candle bodies
extern int     rectangle_opacity     = 20;    // Opacity of rectangles (0-100)

// NEW: Middle line settings for marked candle zones
extern string  MARKED_CANDLE_MIDDLE_LINE  = "==========MARKED CANDLE MIDDLE LINE==========";
extern bool    show_marked_candle_middle_line = true;  // Show middle line for marked candle zones
extern color   marked_candle_middle_line_color = clrYellow; // Color for marked candle middle line
extern int     marked_candle_middle_line_style = 0;    // Style for marked candle middle line
extern int     marked_candle_middle_line_width = 1;    // Width for marked candle middle line

// NEW: Separate colors for filled rectangles
extern string  FILLED_RECTANGLE_COLORS = "==========FILLED RECTANGLE COLORS==========";
extern color   color_support_filled_possible  = C'0,50,0';        // Dark Green
extern color   color_support_filled_untested  = C'0,100,0';       // Medium Green
extern color   color_support_filled_verified  = C'0,150,0';       // Bright Green
extern color   color_support_filled_weak      = C'100,200,100';   // Light Green
extern color   color_support_filled_turncoat  = C'50,100,50';     // Olive Green
extern color   color_resist_filled_possible   = C'50,0,0';        // Dark Red
extern color   color_resist_filled_untested   = C'100,0,0';       // Medium Red
extern color   color_resist_filled_verified   = C'150,0,0';       // Bright Red
extern color   color_resist_filled_weak       = C'200,100,100';   // Light Red
extern color   color_resist_filled_turncoat   = C'100,50,0';      // Orange-Brown

extern string  ZONE_ALERTS           = "==========ZONE ALERTS==========";
extern bool   zone_show_alerts       = true;
extern bool   zone_alert_popups      = true;
extern bool   zone_alert_sounds      = true;
extern bool   send_email             = false;
extern bool   use_push               = false;
extern int    zone_alert_waitseconds = 300; 

extern string  ZONE_ALERTS_FILTER    = "==========FILTER ALERTS==========";
extern bool   filter_zone_alert      = true;
extern bool   filter_MA              = true;
extern int   TF_MA                  = 60;
extern int   MA_FAST_PERIOD         = 13;
extern int   MA_FAST_METHOD         = 1;
extern int   MA_SLOW_PERIOD         = 48;
extern int   MA_SLOW_METHOD         = 1;

extern string  STYLE_ZONES            = "==========STYLE ZONES==========";
extern bool   zone_merge             = true;
extern bool   zone_extend            = false;
extern bool   zone_solid             = false;
extern int    zone_linewidth         = 1;
extern int    zone_style             = 0;
extern int    ShiftEndRight          = 3;//extend the end of zones 3 bars beyond last bar
extern int    zone_limit             = 1000;
extern bool   zone_show_info         = true;
extern bool   zone_show_size         = false; // Changed to false by default to remove price text
extern int    zone_label_shift       = 3;
extern color  color_label            = clrWhite; //Label color
extern string font_label             = "Courier New"; //Label Font
extern int    size_label             = 9; //Label size

extern string  ZONES_COLOR             = "==========COLOR ZONES==========";
extern color   color_support_possible  = DarkSlateGray;
extern color   color_support_untested  = SeaGreen;
extern color   color_support_verified  = Green;
extern color   color_support_weak      = LimeGreen;
extern color   color_support_turncoat  = OliveDrab;
extern color   color_resist_possible   = Indigo;
extern color   color_resist_untested   = Orchid;
extern color   color_resist_verified   = Crimson;
extern color   color_resist_weak       = Red;
extern color   color_resist_turncoat   = DarkOrange;
extern color   color_broken_weak       = DarkGray;
extern color   color_broken_verified   = Gray;
extern color   color_broken_other      = DimGray;

extern string  ZONE_FRACTALS         = "==========ZONE FRACTALS==========";
extern double zone_fuzzfactor        = 0.75;
extern bool   fractals_show          = false;
extern double fractal_fast_factor    = 3.0;
extern double fractal_slow_factor    = 6.0;

extern string  ZONES_GLOBAL_VAR      = "==========ZONES GLOBAL VARIABLES==========";
extern bool   SetGlobals             = false;

extern string  ZONES_TESTING_MODE    = "==========ZONES TESTING==========";
extern bool   Testing                = false; //TRUE == scrolling back the chart shows PAST zone "look"
extern bool   ShowTestingBtn         = false; //Show button to switch Testing mode On/Off
extern int    TestingBtnX            = 10; //Position of this button
extern int    TestingBtnY            = 120;

// NEW: Button settings for On/Off functionality
extern string  BUTTON_SETTINGS        = "==========ON/OFF BUTTON SETTINGS==========";
extern ENUM_BASE_CORNER   btn_corner            = CORNER_LEFT_UPPER; 
extern string             btn_text              = "SSSR";
extern string             btn_Font              = "Arial";
extern int                btn_FontSize          = 10;                            
extern color              btn_text_ON_color     = clrLime;
extern color              btn_text_OFF_color    = clrRed;
extern string             btn_pressed           = "OFF";            
extern string             btn_unpressed         = "ON";
extern color              btn_background_color  = clrDimGray;
extern color              btn_border_color      = clrBlack;
extern int                button_x              = 10;                                 
extern int                button_y              = 10;                                   
extern int                btn_Width             = 40;                                 
extern int                btn_Height            = 20; 
extern bool               ShowOnOffButton       = true; // Show the On/Off button

// Generate unique IDs for buttons
int UniqueID = MathRand(); // Generate random ID for this indicator instance
string BtnSRTesting = "BtnSRTesting_" + (string)UniqueID;
string BtnOnOff = "BtnSSSROnOff_" + (string)UniqueID; // Unique button ID for On/Off

double FastDnPts[], FastUpPts[];
double SlowDnPts[], SlowUpPts[];

double zone_hi[], zone_lo[];
int    zone_start[], zone_hits[], zone_type[], zone_strength[], zone_end[], zone_count = 0;
bool   zone_turn[];

// Arrays to store the actual candle high and low that formed the zone
double zone_candle_high[], zone_candle_low[];
double zone_candle_open[], zone_candle_close[];

// Global variable to track if indicator is on or off
bool indicator_on = false; // Always start OFF
bool force_recalculation = false; // Flag to force recalculation when turning on
bool first_run = true; // Track first run after initialization

#define ZONE_SUPPORT 1
#define ZONE_RESIST  2
#define ZONE_BROKEN  3

#define ZONE_POSSIBLE  0
#define ZONE_TURNCOAT  1
#define ZONE_UNTESTED  2
#define ZONE_VERIFIED  3
#define ZONE_WEAK      4

#define UP_POINT 1
#define DN_POINT -1

int time_offset = 0;

int LastBar = 0; //Last visible bar on the chart - in Testing mode
bool Initialized = false; //Has the INIT function finished?
double PipSize = 0;

//+------------------------------------------------------------------+
//| Button Create Function                                           |
//+------------------------------------------------------------------+
bool ButtonCreate(const long chart_ID=0, const string name="Button", const int sub_window=0, 
                  const int x=0, const int y=0, const int width=50, const int height=18,
                  const ENUM_BASE_CORNER corner=CORNER_LEFT_UPPER, const string text="Button", 
                  const string font="Arial", const int font_size=10, const color clr=clrBlack,
                  const color back_clr=C'236,233,216', const color border_clr=clrNONE,
                  const bool state=false, const bool back=false, const bool selection=false,
                  const bool hidden=false, const long z_order=15)
{
   ResetLastError();
   if(!ObjectCreate(chart_ID,name,OBJ_BUTTON,sub_window,0,0))
   {
      Print(__FUNCTION__, ": failed to create the button! Error code = ",GetLastError());
      return(false);
   }
   ObjectSetInteger(chart_ID,name,OBJPROP_XDISTANCE,x);
   ObjectSetInteger(chart_ID,name,OBJPROP_YDISTANCE,y);
   ObjectSetInteger(chart_ID,name,OBJPROP_XSIZE,width);
   ObjectSetInteger(chart_ID,name,OBJPROP_YSIZE,height);
   ObjectSetInteger(chart_ID,name,OBJPROP_CORNER,corner);
   ObjectSetString(chart_ID,name,OBJPROP_TEXT,text);
   ObjectSetString(chart_ID,name,OBJPROP_FONT,font);
   ObjectSetInteger(chart_ID,name,OBJPROP_FONTSIZE,font_size);
   ObjectSetInteger(chart_ID,name,OBJPROP_COLOR,clr);
   ObjectSetInteger(chart_ID,name,OBJPROP_BGCOLOR,back_clr);
   ObjectSetInteger(chart_ID,name,OBJPROP_BORDER_COLOR,border_clr);
   ObjectSetInteger(chart_ID,name,OBJPROP_BACK,back);
   ObjectSetInteger(chart_ID,name,OBJPROP_STATE,state);
   ObjectSetInteger(chart_ID,name,OBJPROP_SELECTABLE,selection);
   ObjectSetInteger(chart_ID,name,OBJPROP_SELECTED,selection);
   ObjectSetInteger(chart_ID,name,OBJPROP_HIDDEN,hidden);
   ObjectSetInteger(chart_ID,name,OBJPROP_ZORDER,z_order);
   return(true);
}

//+------------------------------------------------------------------+
//| Create On/Off Button Function                                    |
//+------------------------------------------------------------------+
void CreateOnOffButton()
{
   if (!ShowOnOffButton) return;
   
   string text = indicator_on ? btn_unpressed : btn_pressed;
   color textColor = indicator_on ? btn_text_ON_color : btn_text_OFF_color;
   
   ButtonCreate(0, BtnOnOff, 0, button_x, button_y, btn_Width, btn_Height, btn_corner, 
                text, btn_Font, btn_FontSize, textColor, btn_background_color, btn_border_color, false);
}

//+------------------------------------------------------------------+
//| Handle On/Off Button Click                                       |
//+------------------------------------------------------------------+
void HandleOnOffButtonClick()
{
   if (ObjectGetInteger(0, BtnOnOff, OBJPROP_STATE))
   {
      ObjectSetInteger(0, BtnOnOff, OBJPROP_STATE, false);
      indicator_on = !indicator_on;
      
      // Update button appearance
      if (indicator_on)
      {
         ObjectSetString(0, BtnOnOff, OBJPROP_TEXT, btn_unpressed);
         ObjectSetInteger(0, BtnOnOff, OBJPROP_COLOR, btn_text_ON_color);
         // Force immediate recalculation when turning on
         force_recalculation = true;
         // Process immediately
         ProcessIndicator();
      }
      else
      {
         ObjectSetString(0, BtnOnOff, OBJPROP_TEXT, btn_pressed);
         ObjectSetInteger(0, BtnOnOff, OBJPROP_COLOR, btn_text_OFF_color);
         // Delete all zones and candle marks when turning off
         DeleteZones();
         DeleteCandleMarks();
      }
      
      ChartRedraw();
   }
}

//+------------------------------------------------------------------+
//| Get Pip Info Function                                            |
//+------------------------------------------------------------------+
void GetPipInfo()
{   
   if (Symbol()=="XAUUSD" || Symbol()=="GOLD") 
   {     
      PipSize = 0.1;
   }
   else
   {
     switch (Digits) 
     {
       case 6:
       case 5:
         PipSize = 0.0001;
         break;
       case 4:
         PipSize = 0.0001;
         break;
       case 3:
         PipSize = 0.01;
         break;
       case 2:
         PipSize = 0.01;
         break;
       case 1:
         PipSize = 0.1;
     }
   }  
}

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{  
   Initialized = false;
   
   // Create On/Off button
   if (ShowOnOffButton)
   {
      CreateOnOffButton();
   }
   
   if (ShowTestingBtn){
     if (Testing)
       color Color = C'236,233,216';
     else
       Color = clrSlateGray;
     ButtonCreate(0, BtnSRTesting, 0, TestingBtnX, TestingBtnY, 60, 30, CORNER_LEFT_UPPER, "Testing", "Arial", 8, clrBlack, Color, clrGray, false);
   }   
   GetPipInfo();
   
   IndicatorBuffers(4);

   SetIndexBuffer(0, SlowDnPts);
   SetIndexBuffer(1, SlowUpPts);
   SetIndexBuffer(2, FastDnPts);
   SetIndexBuffer(3, FastUpPts);

   if (fractals_show == true)
   {
      SetIndexStyle(0, DRAW_ARROW, 0, 3);
      SetIndexStyle(1, DRAW_ARROW, 0, 3);
      SetIndexStyle(2, DRAW_ARROW, 0, 1);
      SetIndexStyle(3, DRAW_ARROW, 0, 1);
      SetIndexArrow(0, 218);
      SetIndexArrow(1, 217);
      SetIndexArrow(2, 218);
      SetIndexArrow(3, 217);
   }
   else
   {
      SetIndexStyle(0, DRAW_NONE);
      SetIndexStyle(1, DRAW_NONE);
      SetIndexStyle(2, DRAW_NONE);
      SetIndexStyle(3, DRAW_NONE);
   }

   if (TimeFrame != 1 && TimeFrame != 5 && TimeFrame != 15 &&
       TimeFrame != 60 && TimeFrame != 240 && TimeFrame != 1440 &&
       TimeFrame != 10080 && TimeFrame != 43200)
      TimeFrame = 0;

   if (TimeFrame < Period())
      TimeFrame = Period();

   zone_limit = MathMax(zone_limit, 100);
   ArrayResize(zone_hi, zone_limit);
   ArrayResize(zone_lo, zone_limit);
   ArrayResize(zone_start, zone_limit);
   ArrayResize(zone_hits, zone_limit);
   ArrayResize(zone_type, zone_limit);
   ArrayResize(zone_strength, zone_limit);
   ArrayResize(zone_end, zone_limit);
   ArrayResize(zone_turn, zone_limit);
   
   // Initialize arrays for candle highs, lows, opens and closes
   ArrayResize(zone_candle_high, zone_limit);
   ArrayResize(zone_candle_low, zone_limit);
   ArrayResize(zone_candle_open, zone_limit);
   ArrayResize(zone_candle_close, zone_limit);
   
   Initialized = true;      
   return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
   DeleteZones();
   DeleteGlobalVars();
   DeleteCandleMarks();
   
   ObjectDelete(0, BtnSRTesting);
   ObjectDelete(0, BtnOnOff);
   return(0);
}

//+------------------------------------------------------------------+
//| New Bar Function                                                 |
//+------------------------------------------------------------------+
bool NewBar()
{  
   if (Testing)
     int Shift = LastBar;
   else
     Shift = 0;
   static datetime LastTime = 0;
   if (iTime(NULL, TimeFrame, Shift) != LastTime)
   {
      LastTime = iTime(NULL, TimeFrame, Shift) + time_offset;
      return (true);
   }
   else
      return (false);
}

//+------------------------------------------------------------------+
//| Process Indicator Function - Main logic separated from start()   |
//+------------------------------------------------------------------+
void ProcessIndicator()
{
   if (!indicator_on) 
   {
      DeleteZones();
      DeleteCandleMarks();
      return;
   }
   
   int old_zone_count = zone_count;

   FastFractals();
   SlowFractals();
   DeleteZones();
   DeleteCandleMarks();
   FindZones();
   DrawZones();
   if (mark_candle_high_low) {
      MarkCandleHighLow();
   }
   if (zone_count < old_zone_count)
      DeleteOldGlobalVars(old_zone_count);

   if (zone_show_info == true)
   {  
      for (int i=0; i<zone_count; i++)
      {
         // Apply visibility settings
         if (zone_strength[i] == ZONE_UNTESTED && !zone_show_untested) continue;
         if (zone_strength[i] == ZONE_VERIFIED && !zone_show_verified) continue;
         if (zone_strength[i] == ZONE_WEAK && !zone_show_weak) continue;
         if (zone_strength[i] == ZONE_TURNCOAT && !zone_show_truncoat) continue;
         if (zone_strength[i] == ZONE_POSSIBLE && !zone_show_possible) continue;
         
         string lbl;
         if (zone_strength[i] == ZONE_WEAK)
            lbl = "W H";  // Changed from "W L" to "W H"
         else if (zone_strength[i] == ZONE_VERIFIED)
            lbl = "V H";  // Changed from "V L" to "V H"
         else if (zone_strength[i] == ZONE_UNTESTED)
            lbl = "U H";  // Changed from "U L" to "U H"
         else if (zone_strength[i] == ZONE_TURNCOAT)
            lbl = "T H";  // Changed from "T L" to "T H"
         else
            lbl = "P H";  // Changed from "P L" to "P H"

         if (zone_type[i] == ZONE_SUPPORT)
            lbl = lbl + " H";
         else
            lbl = lbl + " L";
        
         // REMOVED: Price/size display section
         // if (zone_show_size == true)
         // {
         //    int tam = 0;
         //    tam =  (zone_hi[i] - zone_lo[i]) * (MathPow(10,Digits()));
         //    lbl = lbl + "(" + tam + "p)";
         // }              
 
         if (zone_hits[i] > 0 && zone_strength[i] > ZONE_UNTESTED)
         {
            if (zone_hits[i] == 1)
               lbl = lbl + ", Test Count=" + zone_hits[i];                 
            else
               lbl = lbl + ", Test Count=" + zone_hits[i];                 
         }
         
         int adjust_hpos;
         int wbpc = WindowBarsPerChart();
         int k;
         
         k = Period() * 60 + (20 + StringLen(lbl));
         
         if (wbpc < 80)  
            adjust_hpos = iTime(NULL, TimeFrame, LastBar + 0) + k * 4;
         else if (wbpc < 125)  
            adjust_hpos = iTime(NULL, TimeFrame, LastBar + 0) + k * 8;
         else if (wbpc < 250)
            adjust_hpos = iTime(NULL, TimeFrame, LastBar + 0) + k * 15;
         else if (wbpc < 480)
            adjust_hpos = iTime(NULL, TimeFrame, LastBar + 0) + k * 29;
         else if (wbpc < 950)
            adjust_hpos = iTime(NULL, TimeFrame, LastBar + 0) + k * 58;
         else
            adjust_hpos = iTime(NULL, TimeFrame, LastBar + 0) + k * 115;
        
        
         if (LastBar > 0)
           int shift = - 77 * Period() * 60;
         else
           shift = k * zone_label_shift;
           
         double vpos = zone_hi[i] - (zone_hi[i] - zone_lo[i]) / 2;
           
         string s = "SSSR#"+i+"LBL_" + (string)UniqueID;
         ObjectCreate(s, OBJ_TEXT, 0, 0, 0);
         ObjectSet(s, OBJPROP_TIME1, adjust_hpos + shift);
         ObjectSet(s, OBJPROP_PRICE1, vpos);
         ObjectSetText(s, StringRightPad(lbl, 36, " "), size_label, font_label, color_label);
      }
   }
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   // Process on first run, new bar, or when force recalculation is requested
   if (first_run || NewBar() || force_recalculation)
   {  
      ProcessIndicator();
      force_recalculation = false;
      first_run = false;
   }
   
   CheckAlerts();
   return(0);
}

//+------------------------------------------------------------------+
//| New function to mark the high and low of zone-forming candles    |
//+------------------------------------------------------------------+
void MarkCandleHighLow()
{
   for (int i=0; i<zone_count; i++)
   {
      // Apply visibility settings
      if (zone_strength[i] == ZONE_UNTESTED && !zone_show_untested) continue;
      if (zone_strength[i] == ZONE_VERIFIED && !zone_show_verified) continue;
      if (zone_strength[i] == ZONE_WEAK && !zone_show_weak) continue;
      if (zone_strength[i] == ZONE_TURNCOAT && !zone_show_truncoat) continue;
      if (zone_strength[i] == ZONE_POSSIBLE && !zone_show_possible) continue;
      
      // Determine line color based on zone type and settings (for marked lines)
      color lineColor;
      if (use_zone_colors_for_candles) {
         if (zone_type[i] == ZONE_SUPPORT) {
            if (zone_strength[i] == ZONE_TURNCOAT)
               lineColor = color_support_turncoat;
            else if (zone_strength[i] == ZONE_WEAK)
               lineColor = color_support_weak;
            else if (zone_strength[i] == ZONE_VERIFIED)
               lineColor = color_support_verified;
            else if (zone_strength[i] == ZONE_UNTESTED)
               lineColor = color_support_untested;
            else
               lineColor = color_support_possible;
         } else {
            if (zone_strength[i] == ZONE_TURNCOAT)
               lineColor = color_resist_turncoat;
            else if (zone_strength[i] == ZONE_WEAK)
               lineColor = color_resist_weak;
            else if (zone_strength[i] == ZONE_VERIFIED)
               lineColor = color_resist_verified;
            else if (zone_strength[i] == ZONE_UNTESTED)
               lineColor = color_resist_untested;
            else
               lineColor = color_resist_possible;
         }
      } else {
         lineColor = mark_candle_color;
      }
      
      // NEW: Determine filled rectangle color based on zone type and strength (separate from lines)
      color fillColor;
      if (zone_type[i] == ZONE_SUPPORT) {
         if (zone_strength[i] == ZONE_TURNCOAT)
            fillColor = color_support_filled_turncoat;
         else if (zone_strength[i] == ZONE_WEAK)
            fillColor = color_support_filled_weak;
         else if (zone_strength[i] == ZONE_VERIFIED)
            fillColor = color_support_filled_verified;
         else if (zone_strength[i] == ZONE_UNTESTED)
            fillColor = color_support_filled_untested;
         else
            fillColor = color_support_filled_possible;
      } else {
         if (zone_strength[i] == ZONE_TURNCOAT)
            fillColor = color_resist_filled_turncoat;
         else if (zone_strength[i] == ZONE_WEAK)
            fillColor = color_resist_filled_weak;
         else if (zone_strength[i] == ZONE_VERIFIED)
            fillColor = color_resist_filled_verified;
         else if (zone_strength[i] == ZONE_UNTESTED)
            fillColor = color_resist_filled_untested;
         else
            fillColor = color_resist_filled_possible;
      }
      
      // Draw horizontal lines for the actual candle high and low
      string highLineName = "SSSR#CandleHigh#" + (string)i + "_" + (string)UniqueID;
      string lowLineName = "SSSR#CandleLow#" + (string)i + "_" + (string)UniqueID;
      
      // Get the actual candle data for the zone start
      double candleHigh = iHigh(NULL, TimeFrame, zone_start[i]);
      double candleLow = iLow(NULL, TimeFrame, zone_start[i]);
      double candleOpen = iOpen(NULL, TimeFrame, zone_start[i]);
      double candleClose = iClose(NULL, TimeFrame, zone_start[i]);
      
      // Calculate end time for the lines and rectangles (same for both)
      datetime endTime;
      if (LastBar > 0)
         endTime = iTime(NULL, TimeFrame, zone_end[i]) - ShiftEndRight * Period() * 60;
      else
         endTime = iTime(NULL, TimeFrame, zone_end[i]) + ShiftEndRight * Period() * 60;
      
      // Draw high line (using lineColor for marked lines)
      ObjectCreate(highLineName, OBJ_TREND, 0, 0, 0, 0, 0);
      ObjectSet(highLineName, OBJPROP_TIME1, iTime(NULL, TimeFrame, zone_start[i]));
      ObjectSet(highLineName, OBJPROP_TIME2, endTime);
      ObjectSet(highLineName, OBJPROP_PRICE1, candleHigh);
      ObjectSet(highLineName, OBJPROP_PRICE2, candleHigh);
      ObjectSet(highLineName, OBJPROP_RAY, false);
      ObjectSet(highLineName, OBJPROP_COLOR, lineColor);
      ObjectSet(highLineName, OBJPROP_STYLE, mark_candle_style);
      ObjectSet(highLineName, OBJPROP_WIDTH, mark_candle_width);
      ObjectSet(highLineName, OBJPROP_BACK, true);
      
      // Draw low line (using lineColor for marked lines)  
      ObjectCreate(lowLineName, OBJ_TREND, 0, 0, 0, 0, 0);
      ObjectSet(lowLineName, OBJPROP_TIME1, iTime(NULL, TimeFrame, zone_start[i]));
      ObjectSet(lowLineName, OBJPROP_TIME2, endTime);
      ObjectSet(lowLineName, OBJPROP_PRICE1, candleLow);
      ObjectSet(lowLineName, OBJPROP_PRICE2, candleLow);
      ObjectSet(lowLineName, OBJPROP_RAY, false);
      ObjectSet(lowLineName, OBJPROP_COLOR, lineColor);
      ObjectSet(lowLineName, OBJPROP_STYLE, mark_candle_style);
      ObjectSet(lowLineName, OBJPROP_WIDTH, mark_candle_width);
      ObjectSet(lowLineName, OBJPROP_BACK, true);
      
      // Store the actual candle values
      zone_candle_high[i] = candleHigh;
      zone_candle_low[i] = candleLow;
      zone_candle_open[i] = candleOpen;
      zone_candle_close[i] = candleClose;
      
      // Draw middle line for marked candle (between the high and low)
      if (show_marked_candle_middle_line) {
         string middleLineName = "SSSR#CandleMiddle#" + (string)i + "_" + (string)UniqueID;
         double middlePrice = (candleHigh + candleLow) / 2;
         
         ObjectCreate(middleLineName, OBJ_TREND, 0, 0, 0, 0, 0);
         ObjectSet(middleLineName, OBJPROP_TIME1, iTime(NULL, TimeFrame, zone_start[i]));
         ObjectSet(middleLineName, OBJPROP_TIME2, endTime);
         ObjectSet(middleLineName, OBJPROP_PRICE1, middlePrice);
         ObjectSet(middleLineName, OBJPROP_PRICE2, middlePrice);
         ObjectSet(middleLineName, OBJPROP_RAY, false);
         ObjectSet(middleLineName, OBJPROP_COLOR, marked_candle_middle_line_color);
         ObjectSet(middleLineName, OBJPROP_STYLE, marked_candle_middle_line_style);
         ObjectSet(middleLineName, OBJPROP_WIDTH, marked_candle_middle_line_width);
         ObjectSet(middleLineName, OBJPROP_BACK, true);
      }
      
      // Draw filled rectangle covering the same range as marked lines (candle high to low)
      if (show_filled_body) {
         string rectName = "SSSR#CandleBody#" + (string)i + "_" + (string)UniqueID;
         
         // Use the exact same range as the marked lines - from candle high to candle low
         double rectTop = candleHigh;
         double rectBottom = candleLow;
         
         // Create filled rectangle using separate fill colors with opacity
         ObjectCreate(rectName, OBJ_RECTANGLE, 0, iTime(NULL, TimeFrame, zone_start[i]), rectTop, endTime, rectBottom);
         ObjectSet(rectName, OBJPROP_COLOR, ColorToARGB(fillColor, rectangle_opacity));
         ObjectSet(rectName, OBJPROP_BACK, true);
         ObjectSet(rectName, OBJPROP_SELECTABLE, false);
         ObjectSetInteger(0, rectName, OBJPROP_FILL, true);
         ObjectSetInteger(0, rectName, OBJPROP_ALIGN, ALIGN_RIGHT);
      }
   }
}

//+------------------------------------------------------------------+
//| Convert color to ARGB format with opacity                        |
//+------------------------------------------------------------------+
color ColorToARGB(color clr, int alpha)
{
   return((color)((alpha<<24)|clr));
}

//+------------------------------------------------------------------+
//| New function to delete candle marks                              |
//+------------------------------------------------------------------+
void DeleteCandleMarks()
{
   int i = 0;
   while (i < ObjectsTotal())
   {
      string objName = ObjectName(i);
      if (StringFind(objName, "SSSR#CandleHigh#") == 0 || 
          StringFind(objName, "SSSR#CandleLow#") == 0 ||
          StringFind(objName, "SSSR#CandleMiddle#") == 0 ||
          StringFind(objName, "SSSR#CandleBody#") == 0)
      {
         // Check if the object belongs to this indicator instance
         if (StringFind(objName, "_" + (string)UniqueID) > 0)
         {
            ObjectDelete(objName);
         }
         else
         {
            i++;
         }
      }
      else
      {
         i++;
      }
   }
}

//+------------------------------------------------------------------+
//| Fast Fractals Function                                           |
//+------------------------------------------------------------------+
void FastFractals()
{
   int counted = IndicatorCounted();
   int shift, limit;
   int P = TimeFrame * fractal_fast_factor;

   if (counted < 0) return;

   limit = MathMin(LastBar + BackLimit, Bars(NULL, TimeFrame)-1); 

   FastUpPts[0] = 0.0; FastUpPts[1] = 0.0;
   FastDnPts[0] = 0.0; FastDnPts[1] = 0.0;

   for (shift=limit; shift> LastBar + 1; shift--)
   {
      if (Fractal(UP_POINT, P, shift) == true)
         FastUpPts[shift] = iHigh(NULL, TimeFrame, shift);
      else
         FastUpPts[shift] = 0.0;

      if (Fractal(DN_POINT, P, shift) == true)
         FastDnPts[shift] = iLow(NULL, TimeFrame, shift);
      else
         FastDnPts[shift] = 0.0;
   }
}

//+------------------------------------------------------------------+
//| Slow Fractals Function                                           |
//+------------------------------------------------------------------+
void SlowFractals()
{
   int counted = IndicatorCounted();
   int shift, limit;
   int P = TimeFrame * fractal_slow_factor;

   if (counted < 0) return;

   limit = MathMin(LastBar + BackLimit, Bars(NULL, TimeFrame)-1);   

   SlowUpPts[0] = 0.0; SlowUpPts[1] = 0.0;
   SlowDnPts[0] = 0.0; SlowDnPts[1] = 0.0;

   for (shift=limit; shift> LastBar + 1; shift--)
   {
      if (Fractal(UP_POINT, P, shift) == true)
         SlowUpPts[shift] = iHigh(NULL, TimeFrame, shift);
      else
         SlowUpPts[shift] = 0.0;

      if (Fractal(DN_POINT, P, shift) == true)
         SlowDnPts[shift] = iLow(NULL, TimeFrame, shift);
      else
         SlowDnPts[shift] = 0.0;
   }
}

//+------------------------------------------------------------------+
//| Fractal Function                                                 |
//+------------------------------------------------------------------+
bool Fractal(int M, int P, int shift)
{
   if (TimeFrame > P)
      P = TimeFrame;
   
   P = P / TimeFrame*2 + MathCeil(P / TimeFrame / 2);
   
   if (shift < P)
      return(false);

   if (shift > Bars(Symbol(), TimeFrame)-P)
      return(false); 
   
   for (int i=1; i<=P; i++)
   {
      if (M == UP_POINT)
      {
         if (iHigh(NULL, TimeFrame, shift+i) > iHigh(NULL, TimeFrame, shift))
            return(false);
         if (iHigh(NULL, TimeFrame, shift-i) >= iHigh(NULL, TimeFrame, shift))
            return(false);     
      }
      if (M == DN_POINT)
      {
         if (iLow(NULL, TimeFrame, shift+i) < iLow(NULL, TimeFrame, shift))
            return(false);
         if (iLow(NULL, TimeFrame, shift-i) <= iLow(NULL, TimeFrame, shift))
            return(false);
      }        
   }
   return(true);  
}

//+------------------------------------------------------------------+
//| Delete Zones Function                                            |
//+------------------------------------------------------------------+
void DeleteZones()
{
   int len = 5;
   int i = 0;

   while (i < ObjectsTotal())
   {
      string objName = ObjectName(i);
      if (StringSubstr(objName, 0, len) == "SSSR#")
      {
         // Check if the object belongs to this indicator instance
         if (StringFind(objName, "_" + (string)UniqueID) > 0)
         {
            ObjectDelete(objName);
         }
         else
         {
            i++;
         }
      }
      else
      {
         i++;
      }
   }
}

//+------------------------------------------------------------------+
//| Find Zones Function                                              |
//+------------------------------------------------------------------+
void FindZones()
{
   int i, j, shift, bustcount=0, testcount = 0, brokebar;
   double hival, loval;
   bool turned = false, hasturned = false;

   double temp_hi[1000], temp_lo[1000];
   int    temp_start[1000], temp_hits[1000], temp_strength[1000], temp_count = 0;
   bool   temp_turn[1000], temp_merge[1000];
   double bust_hi[1000], bust_lo[1000];
   int    bust_start[1000], bust_hits[1000], bust_strength[1000], bust_end[1000], bust_count = 0;
   bool   bust_turn[1000], bust_merge[1000];
   int merge1[1000], merge2[1000], merge_count = 0;
   int berge1[1000], berge2[1000], berge_count = 0;

   // iterate through zones from oldest to youngest (ignore recent 5 bars),
   // finding those that have survived through to the present...
   for (shift=MathMin(Bars(NULL, TimeFrame)-1, LastBar + BackLimit); shift> LastBar + 5; shift--)
   {
      double atr = iATR(NULL, TimeFrame, 7, shift);
      double fu = atr/2 * zone_fuzzfactor;
      bool isPossible;
      bool touchOk = false;
      bool isBust = false;
      double close = iClose(NULL, TimeFrame, shift);
      double high  = iHigh(NULL, TimeFrame, shift);
      double low   = iLow(NULL, TimeFrame, shift);
      double hi_i;
      double lo_i;

      if (FastUpPts[shift] > 0.001)
      {
         // a zigzag high point
         isPossible = true;
         if (SlowUpPts[shift] > 0.001)
            isPossible = false;

         hival = high;
         if (zone_extend == true)
            hival += fu;

         loval = MathMax(MathMin(close, high-fu), high-fu*2);
         turned = false;
         hasturned = false;
         isBust = false;

         bustcount = 0;
         testcount = 0;
         brokebar = 0;

         for (i=shift-1; i>=LastBar + 0; i--)
         {
            hi_i = iHigh(NULL, TimeFrame, i);
            lo_i = iLow(NULL, TimeFrame, i);

            if ((turned == false && FastUpPts[i] >= loval && FastUpPts[i] <= hival) ||
                (turned == true && FastDnPts[i] <= hival && FastDnPts[i] >= loval))
            {
               // Potential touch, just make sure its been 10+candles since the prev one
               touchOk = true;
               for (j=i+1; j<i+11; j++)
               {
                  if ((turned == false && FastUpPts[j] >= loval && FastUpPts[j] <= hival) ||
                      (turned == true && FastDnPts[j] <= hival && FastDnPts[j] >= loval))
                  {
                     touchOk = false;
                     break;
                  }
               }

               if (touchOk == true)
               {
                  // we have a touch.  If its been busted once, remove bustcount
                  // as we know this level is still valid & has just switched sides
                  bustcount = 0;
                  testcount++;
               }
            }

            if ((turned == false && hi_i > hival) ||
                (turned == true && lo_i < loval))
            {
               // this level has been busted at least once
               bustcount++;
               brokebar = MathMax(brokebar, i);

               if (bustcount > 1 || isPossible == true)
               {
                  // busted twice or more
                  isBust = true;
                  break;
               }

               if (turned == true)
                  turned = false;
               else if (turned == false)
                  turned = true;

               hasturned = true;

               // forget previous hits
               testcount = 0;
            }
         }

         if (isBust == false)
         {
            // level is still valid, add to our list
            temp_hi[temp_count] = hival;
            temp_lo[temp_count] = loval;
            temp_turn[temp_count] = hasturned;
            temp_hits[temp_count] = testcount;
            temp_start[temp_count] = shift;
            temp_merge[temp_count] = false;
            
            if (testcount > 3)
               temp_strength[temp_count] = ZONE_WEAK;
            else if (testcount > 0)
               temp_strength[temp_count] = ZONE_VERIFIED;
            else if (hasturned == true)
               temp_strength[temp_count] = ZONE_TURNCOAT;
            else if (isPossible == false)
               temp_strength[temp_count] = ZONE_UNTESTED;
            else
               temp_strength[temp_count] = ZONE_POSSIBLE;

            temp_count++;
         }
         else if (zone_showbroken)
         {
            // level is broken, but we're showing it anyway
            bust_hi[bust_count] = hival;
            bust_lo[bust_count] = loval;
            bust_turn[bust_count] = hasturned;
            bust_hits[bust_count] = testcount;
            bust_start[bust_count] = shift;
            bust_end[bust_count] = brokebar;
            bust_merge[bust_count] = false;

            if (testcount > 3)
               bust_strength[bust_count] = ZONE_WEAK;
            else if (testcount > 0)
               bust_strength[bust_count] = ZONE_VERIFIED;
            else if (hasturned == true)
               bust_strength[bust_count] = ZONE_TURNCOAT;
            else if (isPossible == false)
               bust_strength[bust_count] = ZONE_UNTESTED;
            else
               bust_strength[bust_count] = ZONE_POSSIBLE;

            bust_count++;
         }
      }
      else if (FastDnPts[shift] > 0.001)
      {
         // a zigzag low point
         isPossible = true;
         if (SlowDnPts[shift] > 0.001)
            isPossible = false;

         loval = low;
         if (zone_extend == true)
            loval -= fu;

         hival = MathMin(MathMax(close, low+fu), low+fu*2);
         turned = false;
         hasturned = false;

         bustcount = 0;
         testcount = 0;
         brokebar  = 0;
         isBust = false;

         for (i=shift-1; i>=LastBar + 0; i--)
         {
            hi_i = iHigh(NULL, TimeFrame, i);
            lo_i = iLow(NULL, TimeFrame, i);

            if ((turned == true && FastUpPts[i] >= loval && FastUpPts[i] <= hival) ||
                (turned == false && FastDnPts[i] <= hival && FastDnPts[i] >= loval))
            {
               // Potential touch, just make sure its been 10+candles since the prev one
               touchOk = true;
               for (j=i+1; j<i+11; j++)
               {
                  if ((turned == true && FastUpPts[j] >= loval && FastUpPts[j] <= hival) ||
                      (turned == false && FastDnPts[j] <= hival && FastDnPts[j] >= loval))
                  {
                     touchOk = false;
                     break;
                  }
               }

               if (touchOk == true)
               {
                  // we have a touch.  If its been busted once, remove bustcount
                  // as we know this level is still valid & has just switched sides
                  bustcount = 0;
                  testcount++;
               }
            }

            if ((turned == true && hi_i > hival) ||
                (turned == false && lo_i < loval))
            {
               // this level has been busted at least once
               bustcount++;
               brokebar = MathMax(brokebar, i);

               if (bustcount > 1 || isPossible == true)
               {
                  // busted twice or more
                  isBust = true;
                  break;
               }

               if (turned == true)
                  turned = false;
               else if (turned == false)
                  turned = true;

               hasturned = true;

               // forget previous hits
               testcount = 0;
            }
         }

         if (isBust == false)
         {
            // level is still valid, add to our list
            temp_hi[temp_count] = hival;
            temp_lo[temp_count] = loval;
            temp_turn[temp_count] = hasturned;
            temp_hits[temp_count] = testcount;
            temp_start[temp_count] = shift;
            temp_merge[temp_count] = false;

            if (testcount > 3)
               temp_strength[temp_count] = ZONE_WEAK;
            else if (testcount > 0)
               temp_strength[temp_count] = ZONE_VERIFIED;
            else if (hasturned == true)
               temp_strength[temp_count] = ZONE_TURNCOAT;
            else if (isPossible == false)
               temp_strength[temp_count] = ZONE_UNTESTED;
            else
               temp_strength[temp_count] = ZONE_POSSIBLE;

            temp_count++;
         }
         else if (zone_showbroken)
         {
            // level is broken, but we're showing it anyway
            bust_hi[bust_count] = hival;
            bust_lo[bust_count] = loval;
            bust_turn[bust_count] = hasturned;
            bust_hits[bust_count] = testcount;
            bust_start[bust_count] = shift;
            bust_end[bust_count] = brokebar;
            bust_merge[bust_count] = false;

            if (testcount > 3)
               bust_strength[bust_count] = ZONE_WEAK;
            else if (testcount > 0)
               bust_strength[bust_count] = ZONE_VERIFIED;
            else if (hasturned == true)
               bust_strength[bust_count] = ZONE_TURNCOAT;
            else if (isPossible == false)
               bust_strength[bust_count] = ZONE_UNTESTED;
            else
               bust_strength[bust_count] = ZONE_POSSIBLE;

            bust_count++;
         }
      }
   }

   // look for overlapping zones...
   if (zone_merge == true)
   {
      merge_count = 1;
      int iterations = 0, target, source;
      while (merge_count > 0 && iterations < 3)
      {
         merge_count = 0;
         iterations++;

         for (i = 0; i < temp_count; i++)
            temp_merge[i] = false;

         for (i = 0; i < temp_count-1; i++)
         {
            if (temp_hits[i] == -1 || temp_merge[j] == true)
               continue;

            for (j = i+1; j < temp_count; j++)
            {
               if (temp_hits[j] == -1 || temp_merge[j] == true)
                  continue;

               if ((temp_hi[i] >= temp_lo[j] && temp_hi[i] <= temp_hi[j]) ||
                   (temp_lo[i] <= temp_hi[j] && temp_lo[i] >= temp_lo[j]) ||
                   (temp_hi[j] >= temp_lo[i] && temp_hi[j] <= temp_hi[i]) ||
                   (temp_lo[j] <= temp_hi[i] && temp_lo[j] >= temp_lo[i]))
               {
                  merge1[merge_count] = i;
                  merge2[merge_count] = j;
                  temp_merge[i] = true;
                  temp_merge[j] = true;
                  merge_count++;
               }
            }
         }

         // ... and merge them ...
         for (i=0; i<merge_count; i++)
         {
            target = merge1[i];
            source = merge2[i];

            temp_hi[target] = MathMax(temp_hi[target], temp_hi[source]);
            temp_lo[target] = MathMin(temp_lo[target], temp_lo[source]);
            temp_hits[target] += temp_hits[source];
            temp_start[target] = MathMax(temp_start[target], temp_start[source]);
            temp_strength[target] = MathMax(temp_strength[target], temp_strength[source]);
            if (temp_hits[target] > 3)
               temp_strength[target] = ZONE_WEAK;

            if (temp_hits[target] == 0 && temp_turn[target] == false)
            {
               temp_hits[target] = 1;
               if (temp_strength[target] < ZONE_VERIFIED)
                  temp_strength[target] = ZONE_VERIFIED;
            }

            if (temp_turn[target] == false || temp_turn[source] == false)
               temp_turn[target] = false;
            if (temp_turn[target] == true)
               temp_hits[target] = 0;

            temp_hits[source] = -1;
         }
      }
   
      if (zone_showbroken)
      {
         // merge busted zones
         berge_count = 1;
         iterations = 0;
         while (berge_count > 0 && iterations < 3)
         {
            berge_count = 0;
            iterations++;
   
            for (i = 0; i < bust_count; i++)
               bust_merge[i] = false;

            for (i = 0; i < bust_count-1; i++)
            {
               if (bust_hits[i] == -1 || bust_merge[j] == true)
                  continue;

               for (j = i+1; j < bust_count; j++)
               {
                  if (bust_hits[j] == -1 || bust_merge[j] == true)
                     continue;

                  if ((bust_hi[i] >= bust_lo[j] && bust_hi[i] <= bust_hi[j]) ||
                      (bust_lo[i] <= bust_hi[j] && bust_lo[i] >= bust_lo[j]) ||
                      (bust_hi[j] >= bust_lo[i] && bust_hi[j] <= bust_hi[i]) ||
                      (bust_lo[j] <= bust_hi[i] && bust_lo[j] >= bust_lo[i]))
                  {
                     berge1[berge_count] = i;
                     berge2[berge_count] = j;
                     bust_merge[i] = true;
                     bust_merge[j] = true;
                     berge_count++;
                  }
               }
            }

            // ... and merge them ...
            for (i=0; i<berge_count; i++)
            {
               target = berge1[i];
               source = berge2[i];

               bust_hi[target] = MathMax(bust_hi[target], bust_hi[source]);
               bust_lo[target] = MathMin(bust_lo[target], bust_lo[source]);
               bust_hits[target] += bust_hits[source];
               bust_start[target] = MathMax(bust_start[target], bust_start[source]);
               bust_end[target] = MathMax(bust_end[target], bust_end[source]);
               bust_strength[target] = MathMax(bust_strength[target], bust_strength[source]);
               if (bust_hits[target] > 3)
                  bust_strength[target] = ZONE_WEAK;

               if (bust_hits[target] == 0 && bust_turn[target] == false)
               {
                  bust_hits[target] = 1;
                  if (bust_strength[target] < ZONE_VERIFIED)
                     bust_strength[target] = ZONE_VERIFIED;
               }

               if (bust_turn[target] == false || bust_turn[source] == false)
                  bust_turn[target] = false;
               if (bust_turn[target] == true)
                  bust_hits[target] = 0;

               bust_hits[source] = -1;
            }
         }
      }
   }

   // copy the remaining list into our official zones arrays
   zone_count = 0;
   for (i=0; i<temp_count; i++)
   {
      if (temp_hits[i] >= 0 && zone_count < zone_limit)
      {
         zone_hi[zone_count]       = temp_hi[i];
         zone_lo[zone_count]       = temp_lo[i];
         zone_hits[zone_count]     = temp_hits[i];
         zone_turn[zone_count]     = temp_turn[i];
         zone_start[zone_count]    = temp_start[i];
         zone_strength[zone_count] = temp_strength[i];
         zone_end[zone_count]      = LastBar + 0;
         
         if (zone_hi[zone_count] < iClose(NULL, TimeFrame, LastBar + 4))
            zone_type[zone_count] = ZONE_SUPPORT;
         else if (zone_lo[zone_count] > iClose(NULL, TimeFrame, LastBar + 4))
            zone_type[zone_count] = ZONE_RESIST;
         else
         {
            for (j=LastBar + 5; j< LastBar + 1000; j++)
            {
               if (iClose(NULL, TimeFrame, j) < zone_lo[zone_count])
               {
                  zone_type[zone_count] = ZONE_RESIST;
                  break;
               }
               else if (iClose(NULL, TimeFrame, j) > zone_hi[zone_count])
               {
                  zone_type[zone_count] = ZONE_SUPPORT;
                  break;
               }
            }

            if (j == LastBar + 1000)
               zone_type[zone_count] = ZONE_SUPPORT;
         }

         zone_count++;
      }
   }

   if (zone_showbroken)
   {
      for (i=bust_count-1; i>=0; i--)
      {
         if (bust_hits[i] >= 0 && zone_count < zone_limit)
         {
            zone_hi[zone_count]       = bust_hi[i];
            zone_lo[zone_count]       = bust_lo[i];
            zone_hits[zone_count]     = bust_hits[i];
            zone_turn[zone_count]     = bust_turn[i];
            zone_start[zone_count]    = bust_start[i];
            zone_strength[zone_count] = bust_strength[i];
            zone_end[zone_count]      = bust_end[i];
            zone_type[zone_count]     = ZONE_BROKEN;
            zone_count++;
         }
      }
   }
}

//+------------------------------------------------------------------+
//| Draw zones function                                              |
//+------------------------------------------------------------------+
void DrawZones()
{
   // Zone rectangles are now disabled by default (zone_show_zones = false)
   // Only set global variables if needed
   if (SetGlobals == true)
   {
      GlobalVariableSet("SSSR_Count_"+Symbol()+TimeFrame, zone_count);
      GlobalVariableSet("SSSR_Updated_"+Symbol()+TimeFrame, TimeCurrent());
   }

   for (int i=0; i<zone_count; i++)
   {
      if (SetGlobals == true && zone_type[i] != ZONE_BROKEN)
      {
         GlobalVariableSet("SSSR_HI_"+Symbol()+TimeFrame+i, zone_hi[i]);
         GlobalVariableSet("SSSR_LO_"+Symbol()+TimeFrame+i, zone_lo[i]);
         GlobalVariableSet("SSSR_HITS_"+Symbol()+TimeFrame+i, zone_hits[i]);
         GlobalVariableSet("SSSR_STRENGTH_"+Symbol()+TimeFrame+i, zone_strength[i]);
         GlobalVariableSet("SSSR_AGE_"+Symbol()+TimeFrame+i, zone_start[i]);
      }
   }
}

//+------------------------------------------------------------------+
//| Delete Global Variables Function                                 |
//+------------------------------------------------------------------+
void DeleteGlobalVars()
{
   if (SetGlobals == false)
      return;

   GlobalVariableDel("SSSR_Count_"+Symbol()+TimeFrame);
   GlobalVariableDel("SSSR_Updated_"+Symbol()+TimeFrame);

   int old_count = zone_count;
   zone_count = 0;
   DeleteOldGlobalVars(old_count);
}

//+------------------------------------------------------------------+
//| Delete Old Global Variables Function                             |
//+------------------------------------------------------------------+
void DeleteOldGlobalVars(int old_count)
{
   if (SetGlobals == false)
      return;

   for (int i=zone_count; i<old_count; i++)
   {
      GlobalVariableDel("SSSR_HI_"+Symbol()+TimeFrame+i);
      GlobalVariableDel("SSSR_LO_"+Symbol()+TimeFrame+i);
      GlobalVariableDel("SSSR_HITS_"+Symbol()+TimeFrame+i);
      GlobalVariableDel("SSSR_STRENGTH_"+Symbol()+TimeFrame+i);
      GlobalVariableDel("SSSR_AGE_"+Symbol()+TimeFrame+i);
   }
}

//+------------------------------------------------------------------+
//| String Right Pad Function                                        |
//+------------------------------------------------------------------+
string StringRightPad(string str, int n=1, string str2=" ")
{
  return(str + StringRepeat(str2,n-StringLen(str)));
}

//+------------------------------------------------------------------+
//| String Repeat Function                                           |
//+------------------------------------------------------------------+
string StringRepeat(string str, int n = 1)
{
  string outstr = "";
  for(int i = 0; i < n; i++) outstr = outstr + str;
  return(outstr);
}

//+------------------------------------------------------------------+
//| Check Alerts Function                                            |
//+------------------------------------------------------------------+
void CheckAlerts()
{
   static int lastalert = 0;

   if (zone_show_alerts == false)
      return;

   if (Time[0] - lastalert > zone_alert_waitseconds)
      if (CheckEntryAlerts() == true)
         lastalert = Time[0];
}

//+------------------------------------------------------------------+
//| Check Entry Alerts Function                                      |
//+------------------------------------------------------------------+
bool CheckEntryAlerts()
{
   // check for entries
   bool OK_ALERT = false;
      
   for (int i=0; i<zone_count; i++)
   {   
      OK_ALERT = false;
         
      if (Close[0] >= zone_lo[i] && Close[0] < zone_hi[i])
      {
         if (zone_show_alerts == true)
         {         
         
            if (zone_strength[i] == ZONE_UNTESTED && zone_show_untested == true)
            {
               OK_ALERT = true;
            }
            
            if (zone_strength[i] == ZONE_VERIFIED && zone_show_verified == true)
            {
               OK_ALERT = true;
            }
            
            if (zone_strength[i] == ZONE_WEAK && zone_show_weak == true)
            {
               OK_ALERT = true;
            }
             
            if (zone_strength[i] == ZONE_TURNCOAT && zone_show_truncoat == true)
            {
               OK_ALERT = true;
            }
            
            if (zone_strength[i] == ZONE_POSSIBLE && zone_show_possible == true)
            {
               OK_ALERT = true;
            }
            
            if((filter_zone_alert == true) && (filter_MA == true) && (OK_ALERT == true))
            {
               double FMA = iMA(NULL,TF_MA,MA_FAST_PERIOD,0,MA_FAST_METHOD,PRICE_CLOSE,0);
               double SMA = iMA(NULL,TF_MA,MA_SLOW_PERIOD,0,MA_SLOW_METHOD,PRICE_CLOSE,0);
               
               if((FMA >= SMA) && (zone_type[i] == ZONE_RESIST))
               {
                  OK_ALERT = false;
               }
               
               if ((FMA <= SMA) && (zone_type[i] == ZONE_SUPPORT)) 
               {
                  OK_ALERT = false; 
               } 
                                    
            }
            
            if ((zone_alert_popups == true) && (OK_ALERT == true))
            {
               if (zone_type[i] == ZONE_SUPPORT)
                  Alert(Symbol() + TimeFrameToString(TimeFrame) + ": [H] Zone Entered");
               else
                  Alert(Symbol() + TimeFrameToString(TimeFrame) + ": [L] Zone Entered");
            }
            

            if ((zone_alert_sounds == true) && (OK_ALERT == true))
            {
               PlaySound("alert.wav");
            }
            
            if ((send_email == true) && (OK_ALERT == true))
            {
               string dir = "";
               string msg = StringConcatenate(Symbol(), "-", TimeFrameToString(TimeFrame), " at ", TimeToStr(Time[0], TIME_DATE|TIME_SECONDS),
                                              " ", dir, " Zone Entered");
               if (zone_type[i] == ZONE_SUPPORT)
               {
                  dir = "H";
                  SendMail("SS_SupRes_v7.5 alert", msg);
               }
               else
               {
                  dir = "L";
                  SendMail("SS_SupRes_v7.5 alert", msg);
               }
            }
            
            if ((use_push == true) && (OK_ALERT == true))
            {
               string dirp = "";
               string msgp = StringConcatenate(Symbol(), "-", TimeFrameToString(TimeFrame), " at ", TimeToStr(Time[0], TIME_DATE|TIME_SECONDS),
                                              " ", dirp, " Zone Entered");
               if (zone_type[i] == ZONE_SUPPORT)
               {
                  dirp = "[H]";
                  SendNotification("SS_SupRes_v07.5 alert" + msgp);
               }
               else
               {
                  dirp = "[L]";
                  SendNotification("SS_SupRes_v07.5 alert: " + msgp);
               }
                msgp = StringConcatenate(Symbol(), "-", TimeFrameToString(TimeFrame), " at ", TimeToStr(Time[0], TIME_DATE|TIME_SECONDS),
                                              " ", dirp, " Zone Entered");
               
               SendNotification("SS_SupRes_v07.5 alert: " + msgp);
            }
         }
         
         return(true);   
      }
   }

   return(false);
}

//+------------------------------------------------------------------+
//| Time Frame to String Function                                    |
//+------------------------------------------------------------------+
string TimeFrameToString(int tf)
{
   string tfs;

   switch(tf)
   {
      case PERIOD_M1:
         tfs = "M1"  ;
         break;
      case PERIOD_M5:
         tfs = "M5"  ;
         break;
      case PERIOD_M15:
         tfs = "M15" ;
         break;
      case PERIOD_M30:
         tfs = "M30" ;
         break;
      case PERIOD_H1:
         tfs = "H1"  ;
         break;
      case PERIOD_H4:
         tfs = "H4"  ;
         break;
      case PERIOD_D1:
         tfs = "D1"  ;
         break;
      case PERIOD_W1:
         tfs = "W1"  ;
         break;
      case PERIOD_MN1:
         tfs = "MN";
   }

   return(tfs);
}

//+------------------------------------------------------------------+
//| Chart Event Handler                                              |
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam)
{   
  if (id == CHARTEVENT_OBJECT_CLICK){
    if (sparam == BtnSRTesting){
      Testing = !Testing;
      if (Testing)
        ObjectSetInteger(0, BtnSRTesting, OBJPROP_BGCOLOR, C'236,233,216');   
      else
        ObjectSetInteger(0, BtnSRTesting, OBJPROP_BGCOLOR, clrSlateGray);
    }
    else if (sparam == BtnOnOff && ShowOnOffButton){
      HandleOnOffButtonClick();
    }
  }
  if (Testing && Initialized && id == CHARTEVENT_CHART_CHANGE){
    int PrevLastBar = LastBar;
    if (LastBar > 0){
      LastBar = 0;
    }
    LastBar = GetNextBar(0);    
    
    if (Testing && PrevLastBar > 0 && LastBar >= 0 && PrevLastBar != LastBar)
      start();
  }
}

//+------------------------------------------------------------------+
//| Get Next Bar Function                                            |
//+------------------------------------------------------------------+
int GetNextBar(int Shift = 0)
{ 
  int MinBar = ChartFirstVisibleBar();
  int ChartW = ChartWidthInBars();
  if (ChartShiftGet())
  {
    double ShiftMargin = ChartShiftSizeGet();
    if (ShiftMargin > 0)
      ChartW = (int)MathRound((100.0 - ShiftMargin)*(double)ChartW/100.0);  
  }
  int MaxBar = MinBar - ChartW;
  MaxBar = MaxBar - Shift;
  if (MaxBar < 0)
    MaxBar = 0;
  return(MaxBar);
}

//+------------------------------------------------------------------+
//| Chart First Visible Bar Function                                 |
//+------------------------------------------------------------------+
int ChartFirstVisibleBar(const long chart_ID=0)
{
   long result=-1;
   ResetLastError();
   if(!ChartGetInteger(chart_ID,CHART_FIRST_VISIBLE_BAR,0,result))
     {
      Print(__FUNCTION__+", Error Code = ",GetLastError());
     }
   return((int)result);
}

//+------------------------------------------------------------------+
//| Chart Width In Bars Function                                     |
//+------------------------------------------------------------------+
int ChartWidthInBars(const long chart_ID=0)
{
   long result=-1;
   ResetLastError();
   if(!ChartGetInteger(chart_ID,CHART_WIDTH_IN_BARS,0,result))
     {
      Print(__FUNCTION__+", Error Code = ",GetLastError());
     }
   return((int)result);
}

//+------------------------------------------------------------------+
//| Chart Shift Size Get Function                                    |
//+------------------------------------------------------------------+
double ChartShiftSizeGet(const long chart_ID=0)
{
   double result=EMPTY_VALUE;
   ResetLastError();
   if(!ChartGetDouble(chart_ID,CHART_SHIFT_SIZE,0,result))
     {
      Print(__FUNCTION__+", Error Code = ",GetLastError());
     }
   return(result);
}

//+------------------------------------------------------------------+
//| Chart Shift Get Function                                         |
//+------------------------------------------------------------------+
bool ChartShiftGet(const long chart_ID=0)
{
   long value;
   ResetLastError();
   if(!ChartGetInteger(chart_ID,CHART_SHIFT,0,value))
     {
      Print(__FUNCTION__+", Error Code = ",GetLastError());
      return(false);
     }
  if (value > 0)
    return(true);
  else
    return(false);
}
//+------------------------------------------------------------------+